<?php

namespace App\Exports;

use App\Models\KelasMapel;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GuruMapelExport implements FromCollection, WithHeadings
{
    protected $kelas_id;

    public function __construct($kelas_id)
    {
        $this->kelas_id = $kelas_id;
    }

    public function collection()
    {
        return KelasMapel::with(['kelas', 'mapel', 'guru.user'])
            ->where('kelas_id', $this->kelas_id)
            ->get()
            ->map(function ($item) {
                return [
                    'nip' => $item->guru->nip ?? '-',
                    'mapel' => $item->mapel->nama ?? '-',
                ];
            });
    }   

    public function headings(): array
    {
        return [
            'nip',
            'mapel',
        ];
    }
}
