<?php

namespace App\Exports;

use App\Models\KehadiranSiswa;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class KehadiranSiswaExport implements FromCollection, WithHeadings
{
    protected $bulanKehadiranId;

    public function __construct($bulanKehadiranId)
    {
        $this->bulanKehadiranId = $bulanKehadiranId;
    }

    public function collection()
    {
        return KehadiranSiswa::with('siswa')
            ->where('bulan_kehadiran_id', $this->bulanKehadiranId)
            ->get()
            ->map(function ($item) {
                return [
                    'nama'  => $item->siswa->name,
                    'nisn'  => optional($item->siswa->siswa)->nisn ?? '-',
                    'sakit' => $item->sakit ?? 0,
                    'izin'  => $item->izin ?? 0,
                    'alpha' => $item->alpha ?? 0,
                ];
            });
    }

    public function headings(): array
    {
        return ['nama', 'nisn', 'sakit', 'izin', 'alpha'];
    }
}
