<?php

namespace App\Exports;

use App\Models\Siswa;
use App\Models\SiswaKelas;
use App\Models\Kelas;
use App\Models\TahunAjaran;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Events\BeforeSheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class SiswaExport implements FromCollection, WithHeadings, WithEvents, WithCustomStartCell
{
    public function collection()
    {
        $tahunAjaranTerbaru = TahunAjaran::orderByDesc('tahun_awal')->first();

        $kelasIds = Kelas::whereHas('semester', function ($q) use ($tahunAjaranTerbaru) {
            $q->where('tahun_ajaran_id', $tahunAjaranTerbaru->id);
        })->pluck('id');

        $siswaIds = SiswaKelas::whereIn('kelas_id', $kelasIds)->pluck('siswa_id');

        $siswas = Siswa::with('user')->whereIn('siswa_id', $siswaIds)->get();

        $no = 1;

        return $siswas->map(function ($siswa) use (&$no) {
            $dokumen = is_array($siswa->dokumen_identitas) ? $siswa->dokumen_identitas : [];
            $alamat = is_array($siswa->alamat_lengkap) ? $siswa->alamat_lengkap : [];
            $bantuan = is_array($siswa->bantuan_sosial) ? $siswa->bantuan_sosial : [];
            $ayah = is_array($siswa->data_ayah) ? $siswa->data_ayah : [];
            $ibu = is_array($siswa->data_ibu) ? $siswa->data_ibu : [];
            $wali = is_array($siswa->data_wali) ? $siswa->data_wali : [];
            $rekening = is_array($siswa->data_rekening) ? $siswa->data_rekening : [];
            $fisik = is_array($siswa->data_fisik) ? $siswa->data_fisik : [];

            return array_merge(
                ['No' => $no++],
                [
                    'Nama' => $siswa->user->name ?? '-',
                    'NIPD' => $siswa->nipd,
                    'JK' => $siswa->jenis_kelamin,
                    'NISN' => $siswa->nisn,
                    'Tempat Lahir' => $siswa->tempat_lahir,
                    'Tanggal Lahir' => $siswa->tanggal_lahir,
                    'NIK' => $dokumen['nik'] ?? '-',
                    'Agama' => $siswa->agama,
                    'Alamat' => $siswa->alamat,
                    'RT' => $alamat['rt'] ?? '',
                    'RW' => $alamat['rw'] ?? '',
                    'Dusun' => $alamat['dusun'] ?? '',
                    'Kelurahan' => $alamat['kelurahan'] ?? '',
                    'Kecamatan' => $alamat['kecamatan'] ?? '',
                    'Kode Pos' => $alamat['kode_pos'] ?? '',
                    'Jenis Tinggal' => $siswa->jenis_tinggal,
                    'Alat Transportasi' => $siswa->alat_transportasi,
                    'Telepon' => $siswa->no_telepon,
                    'HP' => $siswa->no_hp,  
                    'E-Mail' => $siswa->user->email ?? '-',
                    'SKHUN' => $dokumen['skhun'] ?? '-',
                    'Penerima KPS' => $bantuan['penerima_kps'] ?? '-',
                    'No. KPS' => $bantuan['no_kps'] ?? '-',
                    // Ayah
                    'Ayah_Nama' => $ayah['nama_ayah'] ?? '',
                    'Ayah_Tahun Lahir' => $ayah['tempat_lahir'] ?? '',
                    'Ayah_Jenjang Pendidikan' => $ayah['pendidikan'] ?? '',
                    'Ayah_Pekerjaan' => $ayah['pekerjaan'] ?? '',
                    'Ayah_Penghasilan' => $ayah['penghasilan'] ?? '',
                    'Ayah_NIK' => $ayah['nik_ayah'] ?? '',
                    // Ibu
                    'Ibu_Nama' => $ibu['nama_ibu'] ?? '',
                    'Ibu_Tahun Lahir' => $ibu['tempat_lahir'] ?? '',
                    'Ibu_Jenjang Pendidikan' => $ibu['pendidikan'] ?? '',
                    'Ibu_Pekerjaan' => $ibu['pekerjaan'] ?? '',
                    'Ibu_Penghasilan' => $ibu['penghasilan'] ?? '',
                    'Ibu_NIK' => $ibu['nik_ibu'] ?? '',
                    // Wali
                    'Wali_Nama' => $wali['nama_wali'] ?? '',
                    'Wali_Tahun Lahir' => $wali['tempat_lahir'] ?? '',
                    'Wali_Jenjang Pendidikan' => $wali['pendidikan'] ?? '',
                    'Wali_Pekerjaan' => $wali['pekerjaan'] ?? '',
                    'Wali_Penghasilan' => $wali['penghasilan'] ?? '',
                    'Wali_NIK' => $wali['nik_wali'] ?? '',
                    'Rombel Saat Ini' => $siswa->rombel_saat_ini ?? '-',
                    'No Peserta Ujian Nasional' => $dokumen['no_peserta_un'] ?? '-',
                    'No Seri Ijazah' => $dokumen['no_seri_ijazah'] ?? '-',
                    'Penerima KIP' => $bantuan['penerima_kip'] ?? '-',
                    'Nomor KIP' => $bantuan['no_kip'] ?? '-',
                    'Nama di KIP' => $bantuan['nama_di_kip'] ?? '-',
                    'Nomor KKS' => $bantuan['no_kks'] ?? '-',
                    'No Registrasi Akta Lahir' => $dokumen['no_reg_akta'] ?? '-',
                    'Bank' => $rekening['bank'] ?? '-',
                    'Nomor Rekening Bank' => $rekening['nomor'] ?? '-',
                    'Rekening Atas Nama' => $rekening['atas_nama'] ?? '-',
                    'Layak PIP (usulan dari sekolah)' => $bantuan['layak_pip'] ?? '-',
                    'Alasan Layak PIP' => $bantuan['alasan_layak_pip'] ?? '-',
                    'Kebutuhan Khusus' => $siswa->berkebutuhan_khusus ?? '-',
                    'Sekolah Asal' => $siswa->sekolah_asal ?? '-',
                    'Anak ke-berapa' => $siswa->anak_ke ?? '-',
                    'Lintang' => $siswa->lintang ?? '-',
                    'Bujur' => $siswa->bujur ?? '-',
                    'No KK' => $dokumen['no_kk'] ?? '-',
                    'Berat Badan' => $fisik['berat'] ?? '-',
                    'Tinggi Badan' => $fisik['tinggi'] ?? '-',
                    'Lingkar Kepala' => $fisik['lingkar_kepala'] ?? '-',
                    'Jml. Saudara Kandung' => $siswa->jumlah_saudara_kandung ?? '-',
                    'Jarak Rumah ke Sekolah (KM)' => $siswa->jarak_rumah ?? '-',
                ]
            );
        });
    }

    public function headings(): array
    {
        return [
            'No', 'Nama', 'NIPD', 'JK', 'NISN', 'Tempat Lahir', 'Tanggal Lahir', 'NIK', 'Agama', 'Alamat', 'RT', 'RW', 'Dusun', 'Kelurahan',
            'Kecamatan', 'Kode Pos', 'Jenis Tinggal', 'Alat Transportasi', 'Telepon', 'HP', 'E-Mail', 'SKHUN', 'Penerima KPS', 'No. KPS',
            'Nama', 'Tahun Lahir', 'Jenjang Pendidikan', 'Pekerjaan', 'Penghasilan', 'NIK',
            'Nama', 'Tahun Lahir', 'Jenjang Pendidikan', 'Pekerjaan', 'Penghasilan', 'NIK',
            'Nama', 'Tahun Lahir', 'Jenjang Pendidikan', 'Pekerjaan', 'Penghasilan', 'NIK',
            'Rombel Saat Ini', 'No Peserta Ujian Nasional', 'No Seri Ijazah', 'Penerima KIP', 'Nomor KIP', 'Nama di KIP', 'Nomor KKS',
            'No Registrasi Akta Lahir', 'Bank', 'Nomor Rekening Bank', 'Rekening Atas Nama', 'Layak PIP (usulan dari sekolah)',
            'Alasan Layak PIP', 'Kebutuhan Khusus', 'Sekolah Asal', 'Anak ke-berapa', 'Lintang', 'Bujur', 'No KK', 'Berat Badan',
            'Tinggi Badan', 'Lingkar Kepala', 'Jml. Saudara Kandung', 'Jarak Rumah ke Sekolah (KM)',
        ];
    }

    public function startCell(): string
    {
        return 'A0'; // Mulai dari baris ke-3 karena header 2 baris
    }

    public function registerEvents(): array
    {
        return [
            BeforeSheet::class => function (BeforeSheet $event) {
                $sheet = $event->sheet->getDelegate();
                
                // Array kolom untuk merge vertikal (2 baris)
                $singleColumns = [
                    'A' => 'No',
                    'B' => 'Nama', 
                    'C' => 'NIPD',
                    'D' => 'JK',
                    'E' => 'NISN',
                    'F' => 'Tempat Lahir',
                    'G' => 'Tanggal Lahir',
                    'H' => 'NIK',
                    'I' => 'Agama',
                    'J' => 'Alamat',
                    'K' => 'RT',
                    'L' => 'RW',
                    'M' => 'Dusun',
                    'N' => 'Kelurahan',
                    'O' => 'Kecamatan',
                    'P' => 'Kode Pos',
                    'Q' => 'Jenis Tinggal',
                    'R' => 'Alat Transportasi',
                    'S' => 'Telepon',
                    'T' => 'HP',
                    'U' => 'E-Mail',
                    'V' => 'SKHUN',
                    'W' => 'Penerima KPS',
                    'X' => 'No. KPS',
                    'AQ' => 'Rombel Saat Ini',
                    'AR' => 'No Peserta Ujian Nasional',
                    'AS' => 'No Seri Ijazah',
                    'AT' => 'Penerima KIP',
                    'AU' => 'Nomor KIP',
                    'AV' => 'Nama di KIP',
                    'AW' => 'Nomor KKS',
                    'AX' => 'No Registrasi Akta Lahir',
                    'AY' => 'Bank',
                    'AZ' => 'Nomor Rekening Bank',
                    'BA' => 'Rekening Atas Nama',
                    'BB' => 'Layak PIP (usulan dari sekolah)',
                    'BC' => 'Alasan Layak PIP',
                    'BD' => 'Kebutuhan Khusus',
                    'BE' => 'Sekolah Asal',
                    'BF' => 'Anak ke-berapa',
                    'BG' => 'Lintang',
                    'BH' => 'Bujur',
                    'BI' => 'No KK',
                    'BJ' => 'Berat Badan',
                    'BK' => 'Tinggi Badan',
                    'BL' => 'Lingkar Kepala',
                    'BM' => 'Jml. Saudara Kandung',
                    'BN' => 'Jarak Rumah ke Sekolah (KM)'
                ];
                
                // Set single column headers dengan merge vertikal
                foreach ($singleColumns as $col => $header) {
                    $sheet->mergeCells($col . '1:' . $col . '2');
                    $sheet->setCellValue($col . '1', $header);
                }
                
                // Set grup headers untuk data ayah, ibu, wali
                $sheet->mergeCells('Y1:AD1')->setCellValue('Y1', 'Data Ayah');
                $sheet->mergeCells('AE1:AJ1')->setCellValue('AE1', 'Data Ibu');
                $sheet->mergeCells('AK1:AP1')->setCellValue('AK1', 'Data Wali');
                
                // Set sub headers untuk data ayah
                $sheet->setCellValue('Y2', 'Nama');
                $sheet->setCellValue('Z2', 'Tahun Lahir');
                $sheet->setCellValue('AA2', 'Jenjang Pendidikan');
                $sheet->setCellValue('AB2', 'Pekerjaan');
                $sheet->setCellValue('AC2', 'Penghasilan');
                $sheet->setCellValue('AD2', 'NIK');
                
                // Set sub headers untuk data ibu
                $sheet->setCellValue('AE2', 'Nama');
                $sheet->setCellValue('AF2', 'Tahun Lahir');
                $sheet->setCellValue('AG2', 'Jenjang Pendidikan');
                $sheet->setCellValue('AH2', 'Pekerjaan');
                $sheet->setCellValue('AI2', 'Penghasilan');
                $sheet->setCellValue('AJ2', 'NIK');
                
                // Set sub headers untuk data wali
                $sheet->setCellValue('AK2', 'Nama');
                $sheet->setCellValue('AL2', 'Tahun Lahir');
                $sheet->setCellValue('AM2', 'Jenjang Pendidikan');
                $sheet->setCellValue('AN2', 'Pekerjaan');
                $sheet->setCellValue('AO2', 'Penghasilan');
                $sheet->setCellValue('AP2', 'NIK');
                
                // Set styling untuk semua header (baris 1 dan 2)
                $headerRange = 'A1:BN2';
                $sheet->getStyle($headerRange)->applyFromArray([
                    'font' => [
                        'name' => 'Calibri',
                        'size' => 12,
                        'bold' => true,
                    ],
                    'alignment' => [
                        'horizontal' => Alignment::HORIZONTAL_CENTER,
                        'vertical' => Alignment::VERTICAL_CENTER,
                    ],
                ]);
            },
        ];
    }
}