<?php

namespace App\Exports;

use App\Models\SiswaKelas;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class SiswaKelasExport implements FromCollection, WithHeadings
{
    protected $kelas_id;

    public function __construct($kelas_id)
    {
        $this->kelas_id = $kelas_id;
    }

    public function collection()
    {
        return SiswaKelas::with('siswa.user')
            ->where('kelas_id', $this->kelas_id)
            ->get()
            ->map(function ($item) {
                return [
                    'nisn' => $item->siswa->nisn ?? '-',
                ];
            });
    }

    public function headings(): array
    {
        return [
            'nisn',
        ];
    }
}
