<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class KehadiranSiswa extends Model
{
    use SoftDeletes;

    protected $table = 'kehadiran_siswa';
    protected $fillable = ['bulan_kehadiran_id', 'siswa_id', 'sakit', 'izin', 'alpha'];

    public function bulan(): BelongsTo
    {
        return $this->belongsTo(BulanKehadiran::class, 'bulan_kehadiran_id');
    }

    public function siswa(): BelongsTo
    {
        return $this->belongsTo(User::class, 'siswa_id')->withTrashed();
    }
}
