<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SiswaKelas extends Model
{
    use HasFactory;

    protected $table = 'siswa_kelas';
    protected $fillable = ['siswa_id', 'kelas_id'];

    public function siswa()
{
    return $this->belongsTo(Siswa::class, 'siswa_id', 'siswa_id')->with(['user' => function ($query) {
        $query->withTrashed();
    }])->withTrashed();
}


    public function kelas()
    {
        return $this->belongsTo(Kelas::class, 'kelas_id')->withTrashed();
    }

}
