<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;


class User extends Authenticatable
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name', 'email', 'password', 'role',
    ];

    protected $dates = ['deleted_at'];

    public function guru(): HasOne
    {
        return $this->hasOne(Guru::class, 'guru_id', 'id');
    }

    public function siswa(): HasOne
    {
        return $this->hasOne(Siswa::class, 'siswa_id', 'id')->withTrashed();
    }

    
}
