@extends('backend.layout.template_admin')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA SISWA</h4>
      <div class="row mb-3">
  <!-- Tombol Tambah -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createSiswaModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>

  <!-- Tombol Import -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-dark w-100" data-toggle="modal" data-target="#uploadModal">
      <i class="bi bi-upload btn-icon-prepend mr-1"></i> Import
    </button>
  </div>

  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <a href="{{ route('admin.siswa.restoreViewSiswa') }}"
    class="btn btn-light text-dark w-100"
    style="box-shadow: 0 2px 4px rgba(0,0,0,0.2); border: 1px solid #000;">
    <i class="bi bi-journal-text mr-1"></i> Riwayat Siswa
  </a>
</div>

<!-- Search -->
<div class="col-12 col-sm-6 col-md-3 mb-2 w-100">
  <form>
    <input id="search-input" class="form-control" type="search" placeholder="Search NISN / Nama" aria-label="Search">
  </form>
</div>

</div>


<!-- TABEL DATA -->
<div class="table-responsive">
  <table class="table table-striped">
    <thead>
      <tr class="text-center">
        <th>No</th>
        <th>NISN</th>
        <th>Nama</th>
        <th>Email</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      @if ($siswa->isEmpty())
        <tr class="text-center">
          <td colspan="5">Tidak ada data siswa.</td>
        </tr>
      @else
        @foreach ($siswa as $s)
          <tr class="text-center">
            <td>{{ $loop->iteration }}</td>
            <td class="nisn">{{ $s->nisn }}</td>
            <td class="nama">{{ $s->user->name }}</td>
            <td>{{ $s->user->email }}</td>
            <td>
              <form action="{{ route('admin.semuaSiswa.delete', $s->id) }}" method="POST" class="d-inline-block form-delete"
                data-nama="siswa dengan nisn {{ $s->nisn }} yang bernama {{ $s->user->name }}">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                  <i class="mdi mdi-delete-forever"></i>
                </button>
              </form>
            </td>
          </tr>
        @endforeach
      @endif
    </tbody>
  </table>
</div>


<!-- Modal Upload Siswa -->
<div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header d-flex justify-content-between align-items-center">
        <h5 class="modal-title" id="uploadModalLabel">Upload File Excel</h5>
        <div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      </div>

      <form action="{{ route('admin.siswa.import') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="modal-body">
          <div class="form-group">
            <label for="file">File Excel Siswa (.xlsx)</label>
            <input type="file" name="file" class="form-control" required>
            <div class="mt-3">
              <a href="{{ asset('template_import_siswa.xlsx') }}" class="btn btn-primary text-white btn-sm w-100" download>
                Download Template Siswa
              </a>
            </div>
          </div>
        </div>
        <div class="modal-footer w-100">
          <div class="row w-100 d-flex justify-content-between">
            <div class="col-12 col-lg-auto mb-2">
              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
            </div>
            <div class="col-12 col-lg-auto mb-2">
              <button type="submit" class="btn btn-dark w-100 w-lg-auto">Import</button>
            </div>
          </div>
        </div>
      </form>

    </div>
    
  </div>
</div>

<!-- Modal Create Siswa -->
<div class="modal fade" id="createSiswaModal" tabindex="-1" role="dialog" aria-labelledby="createSiswaModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form action="{{ route('admin.siswa.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createSiswaModalLabel">Tambah Siswa</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    
                    <div class="row">
                        {{-- Data User --}}
                        <div class="col-md-4 mb-3">
                            <label>Nama</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control">
                        </div>

                        {{-- Data Siswa --}}
                        <div class="col-md-4 mb-3">
                            <label>NISN</label>
                            <input type="text" name="nisn" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>NIPD</label>
                            <input type="text" name="nipd" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Jenis Kelamin</label>
                            <select name="jenis_kelamin" class="form-control text-dark" required>
                                <option value="" selected hidden>Pilih</option>
                                <option value="L">Laki-laki</option>
                                <option value="P">Perempuan</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Agama</label>
                            <select name="agama" class="form-control text-dark" required>
                                <option value="" selected hidden>Pilih</option>
                                <option value="islam">Islam</option>
                                <option value="kristen">Kristen</option>
                                <option value="katolik">Katolik</option>
                                <option value="hindu">Hindu</option>
                                <option value="buddha">Buddha</option>
                                <option value="konghucu">Konghucu</option>
                                <option value="lainnya">Lainnya</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Tempat Lahir</label>
                            <input type="text" name="tempat_lahir" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Tanggal Lahir</label>
                            <input type="date" name="tanggal_lahir" class="form-control" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Sekolah Asal</label>
                            <input type="text" name="sekolah_asal" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>No Handphone</label>
                            <input type="text" name="no_hp" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>No Telepon</label>
                            <input type="text" name="no_telepon" class="form-control">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Alamat</label>
                            <input type="text" name="alamat" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Jenis Tinggal</label>
                            <select name="jenis_tinggal" class="form-control text-dark" required>
                                <option value="" hidden>Pilih</option>
                                <option value="Bersama Ortu">Bersama Ortu</option>
                                <option value="Ikut Wali">Ikut Wali</option>
                                <option value="Kos">Kos</option>
                                <option value="Asrama">Asrama</option>
                                <option value="Panti Asuhan">Panti Asuhan</option>
                                <option value="Lainnya">Lainnya</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Berkebutuhan Khusus</label>
                            <select name="berkebutuhan_khusus" class="form-control text-dark">
                                <option value="" hidden>Pilih</option>
                                <option value="Tidak">Tidak</option>
                                <option value="Netra">Netra</option>
                                <option value="Rungu">Rungu</option>
                                <option value="Grahita Ringan">Grahita Ringan</option>
                                <option value="Grahita Sedang">Grahita Sedang</option>
                                <option value="Daksa Ringan">Daksa Ringan</option>
                                <option value="Daksa Sedang">Daksa Sedang</option>
                                <option value="Laras">Laras</option>
                                <option value="Wicara">Wicara</option>
                                <option value="Tuna Ganda">Tuna Ganda</option>
                                <option value="Hiper Aktif">Hiper Aktif</option>
                                <option value="Cerdas Istimewa">Cerdas Istimewa</option>
                                <option value="Bakat Istimewa">Bakat Istimewa</option>
                                <option value="Kesulitan Belajar">Kesulitan Belajar</option>
                                <option value="Narkoba">Narkoba</option>
                                <option value="Indigo">Indigo</option>
                                <option value="Down Sindrome">Down Sindrome</option>
                                <option value="Autis">Autis</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Alat Transportasi</label>
                            <input type="text" name="alat_transportasi" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Anak Keberapa</label>
                            <input type="number" name="anak_ke" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Jumlah Saudara Kandung</label>
                            <input type="number" name="jumlah_saudara_kandung" class="form-control" required>
                        </div>
                    </div>

                </div>
                <div class="modal-footer w-100">
                    <div class="row w-100 d-flex justify-content-between">
                        <div class="col-12 col-lg-auto mb-2">
                            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                        </div>
                        <div class="col-12 col-lg-auto mb-2">
                            <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>


<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            html: '{!! str_replace("\n", "<br>", $errors->first()) !!}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            },
        });
    @endif
</script>


<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var nisn = row.querySelector('.nisn')?.textContent.toLowerCase() || '';
            var nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
            var combined = nisn + ' ' + nama;
            if (combined.includes(searchValue)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

@endsection
