@extends('backend.layout.template_admin')
@section('content')

<!-- Include CSS Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />


<style>

.select2-container .select2-selection--single {
    height: 50px; /* tinggi */
    padding: 10px;
    font-size: 16px;
    display: flex;
    align-items: center;
    border-radius: 5px;
    transition: all 0.3s ease; /* haluskan transisi */
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: normal;
    padding-left: 20px; /* tambah padding kiri supaya gak ketiban X */
}

.select2-container--default .select2-selection--single:focus,
.select2-container--default .select2-selection--single:hover {
    border-color: #007bff;
}

.select2-dropdown {
    border-radius: 3px;
    border: 1px solid #007bff;
}

.select2-container--default .select2-selection--single .select2-selection__clear {
    position: absolute;
    left: 10px; /* X pindah ke kiri */
    right: auto;
    top: 50%;
    transform: translateY(-50%);
    font-size: 20px;
    color: #dc3545; /* warna merah Bootstrap danger */
    cursor: pointer;
}

select:invalid {
  color: #6c757d; /* Abu-abu untuk placeholder */
}
select:valid {
  color: #000000; /* Hitam setelah pilih */
}

</style>

<div class="row">
  <div class="col-md-12 grid-margin">
    <div class="row">
      <div class="col-12 col-xl-8 mb-4 mb-xl-0">
        <h3 class="font-weight-bold">Detail Kelas</h3>
        <br>
        <div class="row mb-3">
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form action="{{ route('admin.detailKelas.duplikat') }}" method="POST">
      @csrf
      <button type="submit" class="btn btn-info btn-sm w-100" onclick="return confirm('Tambahkan kelas ke semester 2')">
        <i class="bi bi-plus-square btn-icon-prepend mr-1"></i>
        Semester2
      </button>
    </form>
  </div>

  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <a href="{{ route('admin.kelas.restoreViewKelas') }}"
      class="btn btn-light text-dark btn-sm w-100"
      style="box-shadow: 0 2px 4px rgba(0,0,0,0.2); border: 1px solid #000;">
      <i class="bi bi-journal-text mr-1"></i> Riwayat Kelas
    </a>
  </div>
</div>
      </div>
<style>
  @media (min-width: 992px) {
    /* Di lg ke atas, buat gap horizontal */
    .dropdown-wrapper-lg {
      display: flex !important;
      gap: 1rem; /* jarak antar tombol */
      justify-content: flex-end;
    }
    .dropdown-wrapper-lg > .dropdown {
      flex-grow: 0 !important;
      min-width: 180px;
    }
  }
</style>

<div class="col-12 col-xl-4">
  <div class="d-flex flex-column flex-lg-row dropdown-wrapper-lg">
    <!-- Dropdown Cari Kelas -->
    <div class="dropdown w-100 w-lg-auto mb-2 mb-lg-0 me-lg-2">
      <button
        class="btn btn-sm btn-light bg-white dropdown-toggle w-100"
        type="button"
        id="dropdownMenuDate2"
        data-toggle="dropdown"
        aria-haspopup="true"
        aria-expanded="false"
      >
        <i class="mdi mdi-calendar align-middle"></i>
        <span class="align-middle ms-2">Cari Kelas</span>
      </button>
      <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuDate2">
        <a class="dropdown-item" href="{{ route('admin.kelas.detailKelas') }}">
          Lihat Semua Data
        </a>
        @foreach ($filterOptions as $option)
  <a class="dropdown-item"
     href="{{ route('admin.detailKelas.filter', ['kelas' => $option['nama'], 'tahun_awal' => $option['tahun_awal'], 'tahun_akhir' => $option['tahun_akhir']]) }}">
    Kelas {{ $option['nama'] }} - TA ({{ $option['tahun_awal'] }}/{{ $option['tahun_akhir'] }})
  </a>
@endforeach

      </div>
    </div>

    <!-- Tambahkan Button Hapus Semua -->
    <div class="w-100 w-lg-auto mb-2 mb-lg-0 me-lg-2">
      <form action="{{ route('admin.detailKelas.deleteFiltered') }}" method="POST" class="form-delete-allkelas">
        @csrf
        @foreach ($kelas as $k)
          <input type="hidden" name="kelas_ids[]" value="{{ $k->id }}">
        @endforeach
        <button type="submit" class="btn btn-sm btn-danger w-100">
          <i class="bi bi-trash btn-icon-prepend mr-1"></i> Hapus
        </button>
      </form>
    </div>
    <!-- (Optional) Dropdown Cari Tahun bisa ditambahkan di sini -->
  </div>
</div>




    </div>
  </div>
</div>

<!-- CARD ROW START -->
<div class="row">
  @foreach ($kelas as $k)
    @php
      $class = 'card-tale'; // default
      if (strpos($k->nama, '7') !== false) {
          $class = 'card-tale';
      } elseif (strpos($k->nama, '8') !== false) {
          $class = 'card-light-blue';
      } elseif (strpos($k->nama, '9') !== false) {
          $class = 'card-light-danger';
      }
    @endphp
    <div class="col-md-3 mb-4">
      <div class="card {{ $class }}">
        <div class="card-body">
          <div class="d-flex">
            <div class="d-flex align-items-center justify-content-center" style="width: 50%;">
              <div class="text-center">
                <p class="mb-2" style="font-size: 1.2rem; font-weight: bold;">Kelas</p>
                <p class="mb-0" style="font-size: 1.5rem; font-weight: bold;">{{ $k->nama }}</p>
              </div>
            </div>
            <div style="width: 50%;">
              <div class="d-flex justify-content-end mb-1">
                <button type="button"
                        class="btn btn-sm btn-primary mr-1 btn-add"
                        title="Tambah Siswa dan Guru Mapel"
                        data-toggle="modal"
                        data-target="#ModalSiswaKelasMapel"
                        data-id="{{ $k->id }}">
                    <i class="bi bi-plus"></i>
                </button>
                <button type="button"
                        class="btn btn-sm btn-dark btn-add"
                        title="Import & Export"
                        data-toggle="modal"
                        data-target="#UploadModal"
                        data-id="{{ $k->id }}">
                    <i class="bi bi-file-earmark-text"></i>
                </button>
              </div>
              <div class="d-flex justify-content-end">
                <button class="btn btn-sm btn-success mr-1" title="Detail" data-toggle="modal" data-target="#DetailKelasModal-{{ $k->id }}">
                  <i class="bi bi-eye"></i>
                </button>
                <form action="{{ route('admin.detailKelas.delete', $k->id) }}" method="POST" class="d-inline-block form-delete-kelas"
                data-nama="kelas {{ $k->nama }} semester {{ $k->semester->semester }} TA {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}">
                  @csrf
                    @method('DELETE')
                      <button class="btn btn-sm btn-danger" title="Delete">
                        <i class="bi bi-trash"></i>
                      </button>
                </form>
              </div>
            </div>
          </div>
          <hr>
          <p class="mb-2">Wali Kelas : {{ $k->waliKelas->name }}</p>
          <p>Semester : {{ $k->semester->semester }}</p>
          <p>TA : {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}</p>
          <p>Jumlah siswa : {{ $k->siswaKelas->count() }}</p>
        </div>
      </div>
    </div>
  @endforeach
</div>
<!-- CARD ROW END -->

<!-- Modal Create -->
<div class="modal fade" id="ModalSiswaKelasMapel" tabindex="-1" role="dialog" aria-labelledby="ModalSiswaKelasMapelLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="{{ route('admin.detailKelas.store') }}" method="POST">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Tambah Guru Mapel & Siswa</h5>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body" style="max-height: 70vh; overflow-y: auto;">
          <input type="hidden" name="kelas_id" id="modal-kelas-id">
          <small class="form-text text-muted">Abaikan jika tidak ingin menambahkan guru mapel</small>

          <div id="mapel-container"></div>
          <div class="mb-3">
            <button type="button" class="btn btn-sm btn-dark w-100" id="btnTambahMapel">+ Tambah Guru Mapel</button>
          </div>

          <small class="form-text text-muted">Abaikan jika tidak ingin menambahkan siswa</small>
          <div id="siswa-container"></div>
          <div class="mb-3">
            <button type="button" class="btn btn-sm btn-dark w-100" id="btnTambahSiswa">+ Tambah Siswa</button>
          </div>
        </div>
        <div class="modal-footer w-100">
          <div class="row w-100 d-flex justify-content-between">
            <div class="col-12 col-lg-auto mb-2">
              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
            </div>
            <div class="col-12 col-lg-auto mb-2">
              <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>


 <!-- Modal Detail Kelas -->
  @foreach ($kelas as $k)
  <div class="modal fade" id="DetailKelasModal-{{ $k->id }}" tabindex="-1" role="dialog" aria-labelledby="DetailKelasModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="raporModalLabel">Detail Kelas {{ $k->nama }} Semester {{ $k->semester->semester }} TA {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <!-- Data Guru Mapel -->
<div class="col-lg-6 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Data Guru Mapel</h4>
      <div class="table-responsive mt-3">
        <table class="table table-hover text-center">
          <thead>
            <tr>
              <th>No</th>
              <th>Mata Pelajaran</th>
              <th>Pengajar</th>
              <th>NIP</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @forelse ($k->kelasMapel as $km)
              <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $km->mapel->nama ?? '-' }}</td>
                <td>{{ $km->guru->user->name ?? '-' }}</td>
                <td>{{ $km->guru->nip ?? '-' }}</td>
                <td>
                  <form action="{{ route('admin.kelasMapel.delete', $km->id) }}" method="POST" class="d-inline-block form-delete-guru-mapel"
                  data-nama="mapel {{ $km->mapel->nama }} & pengajar bernama {{ $km->guru->user->name }}">
                      @csrf
                      <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                          <i class="mdi mdi-delete-forever"></i>
                      </button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="5">Tidak ada data guru mapel</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>


<!-- Data Siswa -->
<div class="col-lg-6 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Data Siswa</h4>
      <div class="table-responsive mt-3">
        <table class="table table-hover text-center">
          <thead>
            <tr>
              <th>No</th>
              <th>Nama</th>
              <th>NISN</th>
              <th>Jenis Kelamin</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @forelse ($k->siswaKelas as $sk)
              <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $sk->siswa->user->name ?? '-' }}</td>
                <td>{{ $sk->siswa->nisn ?? '-' }}</td>
                <td>{{ $sk->siswa->jenis_kelamin ?? '-' }}</td>
                <td>
                 <form action="{{ route('admin.siswaKelas.delete', $sk->id) }}" method="POST" class="d-inline-block form-delete-siswa-kelas"
                 data-nama="siswa bernama {{ $sk->siswa->user->name }}">
                    @csrf
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="7">Tidak ada siswa dalam kelas ini</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
        </div> <!-- end row -->
      </div>
    </div>
    </div>
</div>
  @endforeach


<!-- modal upload -->
<div class="modal fade" id="UploadModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="{{ route('admin.detailKelas.import') }}" method="POST" enctype="multipart/form-data">
      @csrf
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="uploadModalLabel">File Excel</h5>
          <div>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
            <div class="row">
              <div class="col-12 col-md-6 mb-2">
                <button type="button" class="btn btn-primary w-100 btn-sm" id="btnExportGuruMapel" data-kelas-id="">
                  Export Mapel
                </button>
              </div>
              <div class="col-12 col-md-6 mb-2">
                <button type="button" class="btn btn-primary btn-sm w-100" id="btnExportSiswaKelas" data-siswa-id="">
                  Export Siswa
                </button>
              </div>
            </div>
          </div>
        </div>
        @if(isset($k))
          <input type="hidden" name="kelas_id" id="upload-kelas-id" value="{{ $k->id }}">
        @endif
        <div class="modal-body">
          <div class="form-group">
            <label for="file">File Excel Guru Mapel (.xlsx)</label>
            <small class="form-text text-muted">Abaikan jika tidak ingin mengimport guru mapel</small>
            <input type="file" name="file_guru_mapel" class="form-control">
            <div class="mt-3">
              <a href="{{ asset('template_import_guru-mapel.xlsx') }}" class="btn btn-primary text-white btn-sm w-100" download>
                Download Template Guru Mapel
              </a>
            </div>
          </div>
          <div class="form-group">
            <label for="file">File Excel Siswa Kelas (.xlsx)</label>
            <small class="form-text text-muted">Abaikan jika tidak ingin mengimport siswa</small>
            <input type="file" name="file_siswa" class="form-control">
            <div class="mt-3">
              <a href="{{ asset('template_import_siswa-kelas.xlsx') }}" class="btn btn-primary text-white btn-sm w-100" download>
                Download Template Siswa Kelas
              </a>
            </div>
          </div>
        </div>
        <div class="modal-footer w-100">
          <div class="row w-100 d-flex justify-content-between">
            <div class="col-12 col-lg-auto mb-2">
              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
            </div>
            <div class="col-12 col-lg-auto mb-2">
              <button type="submit" class="btn btn-dark w-100 w-lg-auto">Import</button>
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Include JS Select2 -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<style>
  .select2-container {
    z-index: 999999 !important;
  }
</style>

@if ($errors->any())
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: @json($errors->first()),
            confirmButtonColor: '#d33',
            customClass: {
            popup: 'swal-popup-tall',
        },
        });
    </script>
@endif

@if (session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: @json(session('success')),
            confirmButtonColor: '#3085d6',
            customClass: {
            popup: 'swal-popup-tall',
        },
        });
    </script>
@endif

@if (session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: '{{ session("success") }}',
            customClass: {
            popup: 'swal-popup-tall',
        },
        });
    </script>
@endif

@if (session('error'))
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            text: '{{ session("error") }}',
            customClass: {
            popup: 'swal-popup-tall',
        },
        });
    </script>
@endif

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-siswa-kelas');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-guru-mapel');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-kelas');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menon-aktifkan ?',
          text: `Data ${nama} ini akan dinon-aktifkan!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-allkelas');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menon-aktifkan ?',
          text: `Semua data Kelas ini akan dinon-aktifkan!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>

<script>
  function getMapelFormHTML() {
    return `
      <div class="form-mapel border rounded p-2 mb-2">
        <div class="form-group">
          <label>Mata Pelajaran</label>
          <select name="mapel_id[]" class="form-control select-mapel" required>
            <option value="">-- Pilih Mata Pelajaran --</option>
            @foreach($mapels as $mapel)
              <option value="{{ $mapel->id }}">{{ $mapel->nama }}</option>
            @endforeach
          </select>
        </div>
        <div class="form-group">
          <label>Pengajar</label>
          <select name="guru_id[]" class="form-control select-guru" required>
            <option value="">-- Pilih Guru --</option>
            @foreach($gurus as $guru)
              <option value="{{ $guru->guru_id }}">{{ $guru->user->name }} ({{ $guru->nip }})</option>
            @endforeach
          </select>
        </div>
        <button type="button" class="btn btn-danger btn-sm mb-2 w-100" onclick="hapusMapel(this)">Hapus Guru Mapel</button>
      </div>`;
  }

  function tambahMapel() {
    const container = document.getElementById('mapel-container');
    const div = document.createElement('div');
    div.innerHTML = getMapelFormHTML();
    container.appendChild(div);

    $(div).find('.select-mapel, .select-guru').select2({
      placeholder: "-- Pilih --",
      allowClear: true,
      width: '100%',
      dropdownParent: $('#ModalSiswaKelasMapel')
    });
  }

  function hapusMapel(button) {
    button.closest('.form-mapel').remove();
  }
</script>


<script>
  function getSiswaFormHTML() {
    return `
      <div class="form-siswa border rounded p-2 mb-2">
        <div class="form-group">
          <label>Siswa</label>
          <select name="siswa_id[]" class="form-control select-siswa" required>
            <option value="">-- Pilih Siswa --</option>
            @foreach($siswas as $siswa)
              <option value="{{ $siswa->siswa_id }}">{{ $siswa->user->name }} ({{ $siswa->nisn }})</option>
            @endforeach
          </select>
        </div>
        <button type="button" class="btn btn-danger btn-sm mb-2 w-100" onclick="hapusSiswa(this)">Hapus Siswa</button>
      </div>`;
  }

  function tambahSiswa() {
    const container = document.getElementById('siswa-container');
    const div = document.createElement('div');
    div.innerHTML = getSiswaFormHTML();
    container.appendChild(div);

    $(div).find('.select-siswa').select2({
      placeholder: "-- Pilih Siswa --",
      allowClear: true,
      width: '100%',
      dropdownParent: $('#ModalSiswaKelasMapel')
    });
  }

  function hapusSiswa(button) {
    button.closest('.form-siswa').remove();
  }
</script>

<script>
  $(document).ready(function () {
    $('#btnTambahMapel').on('click', tambahMapel);
    $('#btnTambahSiswa').on('click', tambahSiswa);

    $('#ModalSiswaKelasMapel').on('hidden.bs.modal', function () {
      $('#mapel-container').empty();
      $('#siswa-container').empty();
    });
  });
</script>

<script>
    $(document).ready(function () {
        $('.btn-add').on('click', function () {
            let kelasId = $(this).data('id');

            // Cek modal target-nya
            let targetModal = $(this).data('target');

            if (targetModal === '#ModalSiswaKelasMapel') {
                $('#modal-kelas-id').val(kelasId);
            } else if (targetModal === '#UploadModal') {
                $('#upload-kelas-id').val(kelasId);
            }
        });
    });
</script>

<script>
  document.querySelectorAll('.btn-add').forEach(function (button) {
    button.addEventListener('click', function () {
      const kelasId = this.getAttribute('data-id');
      document.getElementById('upload-kelas-id').value = kelasId;
      document.getElementById('btnExportGuruMapel').setAttribute('data-kelas-id', kelasId);
      document.getElementById('btnExportSiswaKelas').setAttribute('data-kelas-id', kelasId); // Tambahan untuk siswa
    });
  });

  document.getElementById('btnExportGuruMapel').addEventListener('click', function () {
    const kelasId = this.getAttribute('data-kelas-id');
    if (kelasId) {
      window.location.href = `/admin/kelas/detail-kelas/${kelasId}/export`;
    } else {
      alert("ID Kelas tidak tersedia.");
    }
  });

  // Handler untuk export siswa
  document.getElementById('btnExportSiswaKelas').addEventListener('click', function () {
    const kelasId = this.getAttribute('data-kelas-id');
    if (kelasId) {
      window.location.href = `/admin/siswa/siswa-kelas/${kelasId}/export`;
    } else {
      alert("ID Kelas tidak tersedia.");
    }
  });
</script>


@endsection
