@extends('backend.layout.template_admin')
@section('content')


<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA GURU</h4>
         <div class="row mb-3">
  <!-- Tombol Tambah -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createGuruModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>

  <!-- Tombol Import -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-dark w-100" data-toggle="modal" data-target="#uploadModal">
      <i class="bi bi-arrow-down-up btn-icon-prepend mr-1"></i> Import & Export
    </button>
  </div>

    <div class="col-12 col-sm-6 col-md-3 mb-2">
  <div class="dropdown w-100">
    <button class="btn btn-danger dropdown-toggle w-100" type="button" id="dropdownRoleFilter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      Pilih Role
    </button>
    <div class="dropdown-menu w-100" aria-labelledby="dropdownRoleFilter">
      <a class="dropdown-item {{ request('role') === null ? 'active' : '' }}"
         href="{{ route('backend.admin.guru') }}">
        Semua Data
      </a>
      <a class="dropdown-item {{ request('role') === 'guru' ? 'active' : '' }}"
         href="{{ route('backend.admin.guru', ['role' => 'guru']) }}">
        Guru
      </a>
      <a class="dropdown-item {{ request('role') === 'guru_bk' ? 'active' : '' }}"
         href="{{ route('backend.admin.guru', ['role' => 'guru_bk']) }}">
        Guru BK
      </a>
      <a class="dropdown-item {{ request('role') === 'kepala_sekolah' ? 'active' : '' }}"
         href="{{ route('backend.admin.guru', ['role' => 'kepala_sekolah']) }}">
        Kepala Sekolah
      </a>
    </div>
  </div>
</div>



  <!-- Search -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form>
      <input id="search-input" class="form-control w-100" type="search" placeholder="Search NIP / Nama" aria-label="Search">
    </form>
  </div>

</div>
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
                <th>No</th>
                <th>NIP</th>
                <th>Nama</th>
                <th>Jekel</th>
                <th>No Hp</th>
                <th>Email</th>
                <th>Role</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($guru as $g)
            <tr class="text-center">
                <td>{{ $loop->iteration }}</td>
                <td class="nip">{{ $g->nip }}</td>
                <td class="nama">{{ $g->user->name }}</td>
                <td>{{ $g->jenis_kelamin }}</td>
                <td>{{ $g->no_hp }}</td>
                <td>{{ $g->user->email }}</td>
                <td>{{ $g->user->role }}</td>
                <td>
                <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editGuruModal-{{ $g->id }}">
                  <i class="mdi mdi-pencil"></i>
                </a>
                <form action="{{ route('admin.guru.delete', $g->id) }}" method="POST" class="d-inline-block form-delete"
                data-nama=" guru dengan nip {{ $g->nip }} yang bernama {{ $g->user->name }} ">
                  @csrf
                  @method('DELETE')
                  <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                    <i class="mdi mdi-delete-forever"></i>
                  </button>
                </form>
                </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Modal Edit Guru -->
@foreach ($guru as $g)
<div class="modal fade" id="editGuruModal-{{ $g->id }}" tabindex="-1" role="dialog" aria-labelledby="editGuruModalLabel-{{ $g->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <form action="{{ route('admin.guru.update', $g->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editGuruModalLabel-{{ $g->id }}">Edit Guru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <input type="hidden" name="guru_id" value="{{ $g->guru_id }}">

                    <div class="row">
                      <div class="col-md-12 mb-3">
                          <label>Role</label>
                          <select name="role" class="form-control text-dark" required>
                              <option value="" selected hidden>Pilih</option>
                              <option value="guru" {{ $g->user->role == 'guru' ? 'selected' : '' }}>Guru</option>
                              <option value="guru_bk" {{ $g->user->role == 'guru_bk' ? 'selected' : '' }}>Guru BK</option>
                              <option value="kepala_sekolah" {{ $g->user->role == 'kepala_sekolah' ? 'selected' : '' }}>Kepala Sekolah</option>
                              <option value="admin" {{ $g->user->role == 'admin' ? 'selected' : '' }}>Admin</option>
                          </select>
                      </div>
                        <div class="col-md-4 mb-3">
                            <label>Nama</label>
                            <input type="text" name="name" class="form-control" value="{{ $g->user->name }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="{{ $g->user->email }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Password (kosongkan jika tidak diubah)</label>
                            <input type="password" name="password" class="form-control">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>NIP</label>
                            <input type="text" name="nip" class="form-control" value="{{ $g->nip }}" required>
                        </div>
                       
                        <div class="col-md-4 mb-3">
                            <label>Jenis Kelamin</label>
                            <select name="jenis_kelamin" class="form-control text-dark" required>
                                <option value="" selected hidden>Pilih</option>
                                <option value="L" {{ $g->jenis_kelamin == 'L' ? 'selected' : '' }}>Laki-laki</option>
                                <option value="P" {{ $g->jenis_kelamin == 'P' ? 'selected' : '' }}>Perempuan</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>No Handphone</label>
                            <input type="text" name="no_hp" class="form-control" id="no_hp" value="{{ $g->no_hp }}" required>
                        </div>
                    </div>
                </div>

                <div class="modal-footer w-100">
                    <div class="row w-100 d-flex justify-content-between">
                        <div class="col-12 col-lg-auto mb-2">
                            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                        </div>
                        <div class="col-12 col-lg-auto mb-2">
                            <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach


<!-- modal upload -->
<div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header d-flex justify-content-between align-items-center">
        <h5 class="modal-title" id="uploadModalLabel">Upload File Excel</h5>
        <div>
          <button type="button" id="btnExportGuru" class="btn btn-primary">Export Data Guru</button>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
      </div>
      <form action="{{ route('admin.guru.import') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="modal-body">
          <div class="form-group">
            <label for="file">File Excel Guru (xlsx)</label>
            <input type="file" name="file" class="form-control" required>
            <div class="mt-3">
              <a href="{{ asset('template_import_guru.xlsx') }}" class="btn btn-primary text-white btn-sm w-100" download>
                Download Template Guru
              </a>
            </div>
          </div>
          <div class="form-group mt-3">
            <label for="role">Role</label>
            <select name="role" class="form-control text-dark" required>
              <option value="" selected hidden>Pilih</option>
              <option value="guru">Guru</option>
              <option value="guru_bk">BK</option>
              <option value="kepala_sekolah">Kepala Sekolah</option>
            </select>
          </div>
        </div>    
        <div class="modal-footer w-100">
          <div class="row w-100 d-flex justify-content-between">
            <div class="col-12 col-lg-auto mb-2">
              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
            </div>
            <div class="col-12 col-lg-auto mb-2">
              <button type="submit" class="btn btn-dark w-100 w-lg-auto">Import</button>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="modal fade" id="createGuruModal" tabindex="-1" role="dialog" aria-labelledby="createGuruModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <form action="{{ route('admin.guru.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createGuruModalLabel">Tambah Guru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="form-group">
                        <label>Role</label>
                        <select name="role" class="form-control text-dark" required>
                            <option value="" selected hidden>Pilih</option>
                            <option value="guru">Guru</option>
                            <option value="guru_bk">Guru BK</option>
                            <option value="kepala_sekolah">Kepala Sekolah</option>
                        </select>
                    </div>

                    <div class="row">

                        <div class="col-md-4 mb-3">
                            <label>Nama</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>NIP</label>
                            <input type="text" name="nip" class="form-control" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Jenis Kelamin</label>
                            <select name="jenis_kelamin" class="form-control text-dark" required>
                                <option value="" selected hidden>Pilih</option>
                                <option value="L">Laki-laki</option>
                                <option value="P">Perempuan</option>
                            </select>
                        </div>
                        
                        <div class="col-md-4 mb-3">
                            <label>No Handphone</label>
                            <input type="text" name="no_hp" id="no_hp" class="form-control" required placeholder="+62xxxxxxxxxxx">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Password</label>
                            <input type="password" name="password" id="password" class="form-control" required>
                        </div>

                    </div>
                </div>

                <div class="modal-footer w-100">
                    <div class="row w-100 d-flex justify-content-between">
                        <div class="col-12 col-lg-auto mb-2">
                            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                        </div>
                        <div class="col-12 col-lg-auto mb-2">
                            <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>




<script>
  document.getElementById('btnExportGuru').addEventListener('click', function () {
    window.location.href = "{{ route('admin.guru.export') }}";
  });
</script>

<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var nip = row.querySelector('.nip')?.textContent.toLowerCase() || '';
            var nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
            var combined = nip + ' ' + nama;
            if (combined.includes(searchValue)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>


<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

     @if ($errors->any())
    Swal.fire({
        icon: 'error',
        title: 'Gagal!',
        text: @json($errors->first()),
        confirmButtonColor: '#d33',
        customClass: {
            popup: 'swal-popup-tall',
        },
    });
@endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus ?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const noHpInput = document.getElementById('no_hp');
    noHpInput.addEventListener('input', function () {
        let val = noHpInput.value;
        if (val.startsWith('0')) {
            val = '+62' + val.substring(1);
        }
        if (!val.startsWith('+62')) {
            val = '+62' + val.replace(/^(\+)?(62)?/, '');
        }
        val = '+62' + val.substring(3).replace(/\D/g, '');
        noHpInput.value = val;
    });
});
</script>

@endsection
