@extends('backend.layout.template_admin')
@section('content')

<div class="row">
  <div class="col-md-12 grid-margin">
      <div class="d-flex justify-content-between align-items-center">
        <h4 class="font-weight-bold">Riwayat Kelas</h4>
        <form class="form-inline">
        <input id="search-input" class="form-control" type="search" placeholder="Search Kelas & Tahun" aria-label="Search" data-width="250">
        </form>
    </div>
    <a href="{{ route('admin.kelas.detailKelas') }}" class="btn btn-secondary btn-sm mb-3">
        <i class="bi bi-arrow-left"></i> Kembali
    </a>
    <div class="row">
      @forelse ($deletedKelas as $k)
        <div class="col-md-3 mb-4">
          <div class="card border-warning">
            <div class="card-body">
              <h5 class="text-danger font-weight-bold kelas">Kelas {{ $k->nama }}</h5>
              <p>Wali Kelas: {{ $k->waliKelas->name }}</p>
              <p>Semester: {{ $k->semester->semester }}</p>
              <p class="tahun">TA: {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}</p>
                <div class="d-flex justify-content-between">
                <form action="{{ route('admin.kelas.restoreKelas', $k->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-sm btn-primary" title="Pulihkan" onclick="return confirm('Apakah Anda yakin ingin memulihkan kelas {{ $k->nama }} Semester {{ $k->semester->semester }} TA {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}?')">
                    <i class="bi bi-arrow-clockwise"></i>
                    </button>
                </form>
                <button class="btn btn-sm btn-success ml-2" title="Detail" data-toggle="modal" data-target="#DetailKelasModal-{{ $k->id }}">
                    <i class="bi bi-eye"></i> 
                </button>
                <form action="{{ route('admin.kelas.deleteKelasPermanent', $k->id) }}" method="POST" class="d-inline-block form-delete-kelas"
                data-nama="Kelas {{ $k->nama }} Semester {{ $k->semester->semester }} TA {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}">
                  @csrf
                    @method('DELETE')
                      <button class="btn btn-sm btn-danger" title="Hapus">
                        <i class="bi bi-trash"></i>
                      </button>
                </form>
                </div>
            </div>
          </div>
        </div>
      @empty
        <div class="col-12">
          <div class="alert alert-info">Tidak ada data kelas yang terhapus.</div>
        </div>
      @endforelse
    </div>
  </div>
</div>

@foreach ($deletedKelas as $k)
<div class="modal fade" id="DetailKelasModal-{{ $k->id }}" tabindex="-1" role="dialog" aria-labelledby="DetailKelasModalLabel" aria-hidden="true">
<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="raporModalLabel">Detail Kelas {{ $k->nama }} Semester {{ $k->semester->semester }} TA {{ $k->semester->tahunAjaran->tahun_awal }}/{{ $k->semester->tahunAjaran->tahun_akhir }}</h5>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="row">
        <!-- Data Guru Mapel -->
<div class="col-lg-6 grid-margin stretch-card">
<div class="card">
  <div class="card-body">
    <h4 class="card-title">Data Guru Mapel</h4>
    <div class="table-responsive mt-3">
      <table class="table table-hover text-center">
        <thead>
          <tr>
            <th>No</th>
            <th>Mata Pelajaran</th>
            <th>Pengajar</th>
            <th>NIP</th>
            <th>Aksi</th>
          </tr>
        </thead>
        <tbody>
          @forelse ($k->kelasMapel as $km)
            <tr>
              <td>{{ $loop->iteration }}</td>
              <td>{{ $km->mapel->nama ?? '-' }}</td>
              <td>{{ $km->guru->user->name ?? '-' }}</td>
              <td>{{ $km->guru->nip ?? '-' }}</td>
              <td>
                <form action="{{ route('admin.kelasMapel.delete', $km->id) }}" method="POST" class="d-inline-block form-delete-guru-mapel"
                data-nama="mapel {{ $km->mapel->nama }} & pengajar bernama {{ $km->guru->user->name }}">
                    @csrf
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="5">Tidak ada data guru mapel</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
</div>
</div>


<!-- Data Siswa -->
<div class="col-lg-6 grid-margin stretch-card">
<div class="card">
  <div class="card-body">
    <h4 class="card-title">Data Siswa</h4>
    <div class="table-responsive mt-3">
      <table class="table table-hover text-center">
        <thead>
          <tr>
            <th>No</th>
            <th>Nama</th>
            <th>NISN</th>
            <th>Jenis Kelamin</th>
            <th>Aksi</th>
          </tr>
        </thead>
        <tbody>
          @forelse ($k->siswaKelas as $sk)
            <tr>
              <td>{{ $loop->iteration }}</td>
              <td>{{ $sk->siswa->user->name ?? '-' }}</td>
              <td>{{ $sk->siswa->nisn ?? '-' }}</td>
              <td>{{ $sk->siswa->jenis_kelamin ?? '-' }}</td>
              <td>
               <form action="{{ route('admin.siswaKelas.delete', $sk->id) }}" method="POST" class="d-inline-block form-delete-siswa-kelas"
               data-nama="siswa bernama {{ $sk->siswa->user->name }}">
                @csrf
                <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                    <i class="mdi mdi-delete-forever"></i>
                </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="7">Tidak ada siswa dalam kelas ini</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
</div>
</div>
      </div> <!-- end row -->
    </div>
  </div>
  </div>
</div>
@endforeach


<script>
document.getElementById('search-input').addEventListener('keyup', function () {
    const searchValue = this.value.toLowerCase();
    const cards = document.querySelectorAll('.row .col-md-3');

    cards.forEach(function (card) {
        const kelasText = card.querySelector('.kelas')?.textContent.toLowerCase() || '';
        const tahunText = card.querySelector('.tahun')?.textContent.toLowerCase() || '';

        // ambil TA: 2023/2024 jadi 2023 2024
        const tahunOnly = tahunText.replace(/[^0-9/]/g, '')  // hapus "TA:" dan spasi
                                   .replace('/', ' ');        // ganti / jadi spasi

        const combined = kelasText + ' ' + tahunOnly;

        if (combined.includes(searchValue)) {
            card.style.display = '';
        } else {
            card.style.display = 'none';
        }
    });
});
</script>


<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>

<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '{{ session('success') }}',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if ($errors->any())
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ $errors->first() }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-siswa-kelas');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus permanen ?',
          text: `Data ${nama} ini akan dihapus secara permanen!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-guru-mapel');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus permanen ?',
          text: `Data ${nama} ini akan dihapus secara permanen!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete-kelas');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus permanen ?',
          text: `Data ${nama} ini akan dihapus secara permanen!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

@endsection