@extends('backend.layout.template_admin')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA ADMIN</h4>
       <div class="row mb-3">
  <!-- Tombol Tambah -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createProfilModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>
</div>
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
                <th>Nama Admin</th>
                <th>Email</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($user as $u)
            <tr class="text-center">
                <td>{{ $u->name }}</td>
                <td>{{ $u->email }}</td>
                <td>
                    <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editProfilModal-{{ $u->id }}">
                    <i class="mdi mdi-pencil"></i>
                    </a>
                    <form action="{{ route('admin.profil.delete', $u->id) }}" method="POST" class="d-inline-block form-delete">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                    </form>
                </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- modal create -->
<div class="modal fade" id="createProfilModal" tabindex="-1" role="dialog" aria-labelledby="createProfilModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.profil.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createProfilModalLabel">Tambah Admin</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name" class="form-label">Nama Admin</label>
                        <input type="text" class="form-control" name="name" placeholder="Nama Admin">
                    </div>
                    <div class="form-group">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" placeholder="Email">
                    </div>
                    <div class="form-group">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" class="form-control" name="password" placeholder="Password">
                    </div>
                </div>
                <div class="modal-footer w-100">
                    <div class="row w-100 d-flex justify-content-between">
                        <div class="col-12 col-lg-auto mb-2">
                        <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                        </div>
                        <div class="col-12 col-lg-auto mb-2">
                        <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>


@foreach ($user as $u)
<!-- modal update -->
<div class="modal fade" id="editProfilModal-{{ $u->id }}" tabindex="-1" role="dialog" aria-labelledby="editProfilModalLabel-{{ $u->id }}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.profil.update', $u->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editProfilModalLabel-{{ $u->id }}">Edit Admin</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" value="{{ $u->id }}">
                    <div class="form-group">
                        <label for="name" class="form-label">Nama Admin</label>
                        <input type="text" class="form-control" name="name" value="{{ $u->name }}" placeholder="Nama Admin">
                    </div>
                    <div class="form-group">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" value="{{ $u->email }}" placeholder="Email">
                    </div>
                    <div class="form-group">
                        <label>Password (kosongkan jika tidak diubah)</label>
                        <input type="password" name="password" class="form-control">
                    </div>
                </div>
                 <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                    </div>
                  </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteForms = document.querySelectorAll('.form-delete');
        deleteForms.forEach(form => {
            form.addEventListener('submit', function (e) {
                e.preventDefault(); // tahan submit dulu

                Swal.fire({
                    title: 'Yakin ingin menghapus ?',
                    text: "Data Admin akan dihapus!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Hapus!',
                    cancelButtonText: 'Batal',
                    customClass: {
                      popup: 'swal-popup-tall',
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit(); // baru submit kalau yakin
                    }
                });
            });
        });
    });
</script>

@endsection