@extends('backend.layout.template_admin')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA SEMESTER</h4>
       <div class="row mb-3">
  <!-- Tombol Tambah -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createSemesterModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>
  <!-- Search -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form>
      <input id="search-input" class="form-control w-100" type="search" placeholder="Search Tahun Ajaran" aria-label="Search">
    </form>
  </div>
</div>
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
                <th>No</th>
                <th>Semester</th>
                <th>Tahun Ajaran</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($semester as $smt) <!-- Ganti $guru dengan $g sebagai variabel per item -->
            <tr class="text-center">
                <td>{{ $loop->iteration }}</td> 
                <td>{{ $smt->semester }}</td>
                <td class="tahun">{{ $smt->tahunAjaran->tahun_awal }}/{{ $smt->tahunAjaran->tahun_akhir }}</td>
                <td>
                    <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editSemesterModal-{{ $smt->id }}">
                    <i class="mdi mdi-pencil"></i>
                    </a>
                    <form action="{{ route('admin.semester.delete', $smt->id) }}" method="POST" class="d-inline-block form-delete"
                    data-nama="Semester {{ $smt->semester }} TA {{ $smt->tahunAjaran->tahun_awal }}/{{ $smt->tahunAjaran->tahun_akhir }}">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                    </form>
                </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- modal create -->
<div class="modal fade" id="createSemesterModal" tabindex="-1" role="dialog" aria-labelledby="createSemesterModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.semester.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createSemesterModalLabel">Tambah Semester</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label>Semester</label>
                        <select name="semester" class="form-control text-dark" required>
                            <option value="" selected hidden>Pilih</option>
                            <option value="1">1</option>
                            <option value="2">2</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="tahun_ajaran_id" class="form-label">Tahun Ajaran</label>
                        <select name="tahun_ajaran_id" class="form-control text-dark" required>
                          <option value="" selected hidden>Pilih</option>
                            @foreach ($tahun as $t)
                                <option value="{{ $t->id }}">{{ $t->tahun_awal }} / {{ $t->tahun_akhir }}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="modal-footer w-100">
                <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                    <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                    <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                    </div>
                </div>
                </div>
            </div>
        </form>
    </div>
</div>


@foreach ($semester as $smt)
<!-- modal update -->
<div class="modal fade" id="editSemesterModal-{{ $smt->id }}" tabindex="-1" role="dialog" aria-labelledby="editSemesterModalLabel-{{ $smt->id }}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.semester.update', $smt->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editGuruModalLabel-{{ $smt->id }}">Edit Semester</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <input type="hidden" name="id" value="{{ $smt->id }}">

                    <div class="form-group">
                        <label>Semester</label>
                        <select name="semester" class="form-control text-dark" required>
                            <option value="" selected hidden>Pilih</option>
                            <option value="1" {{ $smt->semester == '1' ? 'selected' : '' }}>1</option>
                            <option value="2" {{ $smt->semester == '2' ? 'selected' : '' }}>2</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="tahun_ajaran_id" class="form-label">Tahun Ajaran</label>
                        <select name="tahun_ajaran_id" class="form-control text-dark" required>
                            <option value="" selected hidden>Pilih</option>
                            @foreach ($tahun as $t)
                                <option value="{{ $t->id }}" {{ $smt->tahun_ajaran_id == $t->id ? 'selected' : '' }}>{{ $t->tahun_awal }} / {{ $t->tahun_akhir }}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                    </div>
                  </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach


<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var item = row.querySelector('.tahun').textContent.toLowerCase();
            if (item.indexOf(searchValue) > -1) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

@endsection