@extends('backend.layout.template_admin')
@section('content')

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA SISWA AKTIF</h4>
      <div class="row mb-3">

        <div class="col-12 col-sm-6 col-md-3 mb-2">
<form action="{{ route('admin.daftar-ulang.toggle') }}" method="POST" onsubmit="return confirmToggle()">
  @csrf
  <button type="submit" class="btn w-100 
    {{ session('daftar_ulang') ? 'btn-danger' : 'btn-warning' }}">
    <i class="bi {{ session('daftar_ulang') ? 'bi-x-circle text-white' : 'bi-person-check text-dark' }} mr-1"></i>
    <span class="{{ session('daftar_ulang') ? 'text-white' : 'text-dark' }}">
      {{ session('daftar_ulang') ? 'Tutup Daftar Ulang' : 'Buka Daftar Ulang' }}
    </span>
  </button>
</form>
      </div>

  <!-- Tombol Import -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" id="btnExportSiswa" class="btn btn-dark w-100">
      <i class="bi bi-file-earmark-excel btn-icon-prepend mr-1"></i> Export
    </button>
  </div>

  <div class="col-12 col-sm-6 col-md-3 mb-2 w-100" style="visibility: hidden;">

</div>

<!-- Search -->
<div class="col-12 col-sm-6 col-md-3 mb-2 w-100">
  <form>
    <input id="search-input" class="form-control" type="search" placeholder="Search NISN / Nama" aria-label="Search">
  </form>
</div>

</div>



<!-- TABEL DATA -->
<div class="table-responsive">
  <table class="table table-striped">
    <thead>
      <tr class="text-center">
        <th>No</th>
        <th>NISN</th>
        <th>Nama</th>
        <th>Kelas</th>
        <th>Jekel</th>
        <th>No Hp</th>
        <!-- <th>Email</th> -->
        @if(session('daftar_ulang'))
          <th>Data Berubah</th>
          <th>Keterangan</th>
        @endif
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      @foreach ($siswa as $s)
        <tr class="text-center">
          <td>{{ $loop->iteration }}</td>
          <td class="nisn">{{ $s->nisn }}</td>
          <td class="nama">{{ $s->user->name }}</td>
          <td>
            @php
              $kelasAktif = \App\Models\SiswaKelas::where('siswa_id', $s->siswa_id)
                ->whereHas('kelas.semester.tahunAjaran', function($q) {
                    $q->orderByDesc('tahun_awal')->limit(1);
                })
                ->with('kelas')
                ->latest()
                ->first();
            @endphp
            {{ $kelasAktif->kelas->nama ?? '-' }}
          </td>
          <td>{{ $s->jenis_kelamin }}</td>
          <td>{{ $s->no_hp }}</td>
          <!-- <td>{{ $s->user->email }}</td> -->
          @if(session('daftar_ulang'))
            <td>{{ $s->data_berubah }}</td>
            <td>{{ $s->deskripsi }}</td>
          @endif
          <td>
            <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editSiswaModal-{{ $s->id }}">
              <i class="mdi mdi-pencil"></i>
            </a>
            <a href="#" class="btn btn-success btn-sm text-white" title="Detail" data-toggle="modal" data-target="#detailProfilModal-{{ $s->id }}">
              <i class="bi bi-eye"></i>
            </a>
            <form action="{{ route('admin.siswa.delete', $s->id) }}" method="POST" class="d-inline-block form-delete"
            data-nama="siswa dengan nisn {{ $s->nisn }} yang bernama {{ $s->user->name }}">
              @csrf
              @method('DELETE')
              <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                <i class="mdi mdi-delete-forever"></i>
              </button>
            </form>
          </td>
        </tr>
      @endforeach
    </tbody>
  </table>
</div>
    </div>
  </div>
</div>

@foreach ($siswa as $s)
<div class="modal fade" id="editSiswaModal-{{ $s->id }}" tabindex="-1" role="dialog" aria-labelledby="editSiswaModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form action="{{ route('admin.siswa.update', $s->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Data Siswa</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="siswa_id" value="{{ $s->user->id }}">

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label>Password (isi jika ingin ganti)</label>
                            <input type="password" name="password" class="form-control">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Nama</label>
                            <input type="text" name="name" class="form-control" value="{{ $s->user->name }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="{{ $s->user->email }}" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>NISN</label>
                            <input type="text" name="nisn" class="form-control" value="{{ $s->nisn }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>NIPD</label>
                            <input type="text" name="nipd" class="form-control" value="{{ $s->nipd }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Jenis Kelamin</label>
                            <select name="jenis_kelamin" class="form-control text-dark" required>
                                <option value="" hidden>Pilih</option>
                                <option value="L" {{ $s->jenis_kelamin == 'L' ? 'selected' : '' }}>Laki-laki</option>
                                <option value="P" {{ $s->jenis_kelamin == 'P' ? 'selected' : '' }}>Perempuan</option>
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Agama</label>
                            <select name="agama" class="form-control text-dark" required>
                                <option value="" hidden>Pilih</option>
                                @foreach (['islam','kristen','katolik','hindu','buddha','konghucu','lainnya'] as $agama)
                                    <option value="{{ $agama }}" {{ $s->agama == $agama ? 'selected' : '' }}>{{ ucfirst($agama) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Tempat Lahir</label>
                            <input type="text" name="tempat_lahir" class="form-control" value="{{ $s->tempat_lahir }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Tanggal Lahir</label>
                            <input type="date" name="tanggal_lahir" class="form-control" value="{{ $s->tanggal_lahir }}" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Sekolah Asal</label>
                            <input type="text" name="sekolah_asal" class="form-control" value="{{ $s->sekolah_asal }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>No HP</label>
                            <input type="text" name="no_hp" class="form-control" value="{{ $s->no_hp }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>No Telepon</label>
                            <input type="text" name="no_telepon" class="form-control" value="{{ $s->no_telepon }}">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Alamat</label>
                            <input type="text" name="alamat" class="form-control" value="{{ $s->alamat }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Jenis Tinggal</label>
                            <select name="jenis_tinggal" class="form-control text-dark" required>
                                <option value="" hidden>Pilih</option>
                                @foreach (['Bersama Ortu','Ikut Wali','Kos','Asrama','Panti Asuhan','Lainnya'] as $tinggal)
                                    <option value="{{ $tinggal }}" {{ $s->jenis_tinggal == $tinggal ? 'selected' : '' }}>{{ $tinggal }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Berkebutuhan Khusus</label>
                            <select name="berkebutuhan_khusus" class="form-control text-dark">
                                <option value="" hidden>Pilih</option>
                                @foreach ([
                                    'Tidak', 'Netra', 'Rungu', 'Grahita Ringan', 'Grahita Sedang', 'Daksa Ringan',
                                    'Daksa Sedang', 'Laras', 'Wicara', 'Tuna Ganda', 'Hiper Aktif', 'Cerdas Istimewa',
                                    'Bakat Istimewa', 'Kesulitan Belajar', 'Narkoba', 'Indigo', 'Down Sindrome', 'Autis'
                                ] as $khusus)
                                    <option value="{{ $khusus }}" {{ $s->berkebutuhan_khusus == $khusus ? 'selected' : '' }}>{{ $khusus }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Alat Transportasi</label>
                            <select name="alat_transportasi" class="form-control text-dark" required>
                                <option value="" hidden>Pilih</option>
                                @foreach (['Jalan Kaki', 'Sepeda', 'Antar Jemput', 'Kendaraan Umum'] as $alat)
                                    <option value="{{ $alat }}" {{ $s->alat_transportasi == $alat ? 'selected' : '' }}>{{ $alat }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Anak Keberapa</label>
                            <input type="number" name="anak_ke" class="form-control" value="{{ $s->anak_ke }}" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Jumlah Saudara Kandung</label>
                            <input type="number" name="jumlah_saudara_kandung" class="form-control" value="{{ $s->jumlah_saudara_kandung }}" required>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Rombel Saat Ini</label>
                            <input type="text" name="rombel_saat_ini" class="form-control" value="{{ $s->rombel_saat_ini }}">
                        </div>
                    </div> <!-- .row -->
                </div>

                <div class="modal-footer d-flex justify-content-between">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-warning">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach


<!-- Tambahkan jQuery jika belum -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Tambahkan Bootstrap JS (sudah ada jika pakai modal Bootstrap) -->

@foreach ($siswa as $siswa)
<div class="modal fade" id="detailProfilModal-{{ $siswa->id }}" tabindex="-1" role="dialog" aria-labelledby="detailProfilModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detail Data Siswa</h5>
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
      </div>

      <div class="modal-body">
        {{-- STEP 1 --}}
        <h6 class="text-primary">Step 1: Data Diri</h6>
        <hr>
        @include('backend.siswa.wizard.data_diri')

        {{-- STEP 2 --}}
        <h6 class="text-primary mt-4">Step 2: Alamat Lengkap</h6>
        <hr>
        @include('backend.siswa.wizard.alamat_lengkap')

        {{-- STEP 3 --}}
        <h6 class="text-primary mt-4">Step 3: Dokumen Identitas</h6>
        <hr>
        @include('backend.siswa.wizard.dokumen_identitas')

        {{-- STEP 4 & 5: Orang Tua --}}
          <h6 class="text-primary mt-4">Step 4: Data Ayah</h6>
          <hr>
          @include('backend.siswa.wizard.data_ayah')

          <h6 class="text-primary mt-4">Step 5: Data Ibu</h6>
          <hr>
          @include('backend.siswa.wizard.data_ibu')

        {{-- STEP 6: Wali --}}
          <h6 class="text-primary mt-4">Step 4: Data Wali</h6>
          <hr>
          @include('backend.siswa.wizard.data_wali')

        {{-- STEP 7 --}}
        <h6 class="text-primary mt-4">Step 6: Data Fisik</h6>
        <hr>
        @include('backend.siswa.wizard.data_fisik')

        {{-- STEP 8 --}}
        <h6 class="text-primary mt-4">Step 7: Bantuan Sosial</h6>
        <hr>
        @include('backend.siswa.wizard.bantuan_sosial')

        {{-- STEP 9 --}}
        <h6 class="text-primary mt-4">Step 8: Data Rekening</h6>
        <hr>
        @include('backend.siswa.wizard.data_rekening')
      </div>

      <div class="modal-footer w-100">
        <div class="row w-100 d-flex justify-content-center">
          <div class="col-12 col-lg-auto mb-2">
            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endforeach

<!-- jQuery untuk toggle kolom -->
<script>
  $(document).ready(function () {
    $('#btn-daftar-ulang').click(function () {
      $('.kolom-data-berubah, .kolom-deskripsi').toggleClass('d-none');
    });
  });
</script>

<script>
  function confirmToggle() {
    const isOn = {{ session('daftar_ulang') ? 'true' : 'false' }};
    if (isOn) {
      return confirm("Yakin ingin MEMATIKAN daftar ulang ?");
    } else {
      return confirm("Yakin ingin MENGAKTIFKAN daftar ulang ?");
    }
  }
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll('[id^="detailProfilModal-"]').forEach(function(modal) {
    modal.querySelectorAll('input, textarea, select').forEach(function(el) {
      el.disabled = true;
    });
  });
});
</script>

<script>
  document.getElementById('btnExportSiswa').addEventListener('click', function () {
    window.location.href = "{{ route('admin.siswa.exportSiswa') }}";
  });
</script>

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if (session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ session('error') }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>


<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var nisn = row.querySelector('.nisn')?.textContent.toLowerCase() || '';
            var nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
            var combined = nisn + ' ' + nama;
            if (combined.includes(searchValue)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>



@endsection
