@extends('backend.layout.template_admin')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA RIWAYAT SISWA</h4>
      <div class="row mb-3">
        <!-- Search -->
        <div class="col-12 col-sm-6 col-md-3 mb-2 w-100">
          <form>
            <input id="search-input" class="form-control" type="search" placeholder="Search NISN / Nama" aria-label="Search">
          </form>
        </div>
      </div>
      <!-- TABEL DATA -->
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
              <th>No</th>
              <th>NISN</th>
              <th>Nama</th>
              <th>Email</th>
              <th>Jekel</th>
              <th>No Hp</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($deletedSiswas as $s)
              <tr class="text-center">
              <td>{{ $loop->iteration }}</td>
              <td class="nisn">{{ $s->nisn }}</td>
              <td class="nama">{{ $s->user->name ?? '-' }}</td>
              <td>{{ $s->user->email ?? '-' }}</td>
              <td>{{ $s->jenis_kelamin }}</td>
              <td>{{ $s->no_hp }}</td>
              <td>
                <form action="{{ route('admin.siswa.restoreSiswa', $s->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-sm btn-primary" title="Pulihkan" onclick="return confirm('Apakah kamu yakin ingin memulihkan {{ $s->user->name }}?')">
                    <i class="bi bi-arrow-clockwise"></i>
                    </button>
                </form>
                <a href="#" class="btn btn-success btn-sm text-white" title="Detail" data-toggle="modal" data-target="#detailProfilModal-{{ $s->id }}">
                  <i class="bi bi-eye"></i>
                </a>
                <form action="{{ route('admin.siswa.deleteSiswaPermanent', $s->id) }}" method="POST" class="d-inline-block form-delete"
                data-nama="siswa dengan nisn {{ $s->nisn }} yang bernama {{ $s->user->name }}">
                  @csrf
                  @method('DELETE')
                  <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                    <i class="mdi mdi-delete-forever"></i>
                  </button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Tambahkan jQuery jika belum -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Tambahkan Bootstrap JS (sudah ada jika pakai modal Bootstrap) -->

@foreach ($deletedSiswas as $siswa)
<div class="modal fade" id="detailProfilModal-{{ $siswa->id }}" tabindex="-1" role="dialog" aria-labelledby="detailProfilModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detail Data Siswa</h5>
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
      </div>

      <div class="modal-body">
        {{-- STEP 1 --}}
        <h6 class="text-primary">Step 1: Data Diri</h6>
        <hr>
        @include('backend.siswa.wizard.data_diri')

        {{-- STEP 2 --}}
        <h6 class="text-primary mt-4">Step 2: Alamat Lengkap</h6>
        <hr>
        @include('backend.siswa.wizard.alamat_lengkap')

        {{-- STEP 3 --}}
        <h6 class="text-primary mt-4">Step 3: Dokumen Identitas</h6>
        <hr>
        @include('backend.siswa.wizard.dokumen_identitas')

        {{-- STEP 4 & 5: Orang Tua --}}
          <h6 class="text-primary mt-4">Step 4: Data Ayah</h6>
          <hr>
          @include('backend.siswa.wizard.data_ayah')

          <h6 class="text-primary mt-4">Step 5: Data Ibu</h6>
          <hr>
          @include('backend.siswa.wizard.data_ibu')

        {{-- STEP 6: Wali --}}
          <h6 class="text-primary mt-4">Step 4: Data Wali</h6>
          <hr>
          @include('backend.siswa.wizard.data_wali')

        {{-- STEP 7 --}}
        <h6 class="text-primary mt-4">Step 6: Data Fisik</h6>
        <hr>
        @include('backend.siswa.wizard.data_fisik')

        {{-- STEP 8 --}}
        <h6 class="text-primary mt-4">Step 7: Bantuan Sosial</h6>
        <hr>
        @include('backend.siswa.wizard.bantuan_sosial')

        {{-- STEP 9 --}}
        <h6 class="text-primary mt-4">Step 8: Data Rekening</h6>
        <hr>
        @include('backend.siswa.wizard.data_rekening')
      </div>

      <div class="modal-footer w-100">
        <div class="row w-100 d-flex justify-content-end">
          <div class="col-12 col-lg-auto mb-2">
            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endforeach

<script>
document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll('[id^="detailProfilModal-"]').forEach(function(modal) {
    modal.querySelectorAll('input, textarea, select').forEach(function(el) {
      el.disabled = true;
    });
  });
});
</script>

<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var nisn = row.querySelector('.nisn')?.textContent.toLowerCase() || '';
            var nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
            var combined = nisn + ' ' + nama;
            if (combined.includes(searchValue)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>

<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '{{ session('success') }}',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if ($errors->any())
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ $errors->first() }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus permanen ?',
          text: `Data ${nama} ini akan dihapus secara permanen!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

@endsection

