@extends('backend.layout.template_admin')
@section('content')


<!-- jQuery dan Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- Bootstrap Datepicker CSS & JS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.10.0/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.10.0/dist/js/bootstrap-datepicker.min.js"></script>


<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA TAHUN AJARAN</h4>
       <div class="row mb-3">
  <!-- Tombol Tambah -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createTahunModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>
  <!-- Search -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form>
      <input id="search-input" class="form-control w-100" type="search" placeholder="Search Tahun Ajaran" aria-label="Search">
    </form>
  </div>
</div>
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
                <th>No</th>
                <th>Tahun Awal</th>
                <th>Tahun Akhir</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($tahun as $t)
            <tr class="text-center">
                <td>{{ $loop->iteration }}</td> 
                <td class="tahun">{{ $t->tahun_awal }}</td>
                <td class="tahun">{{ $t->tahun_akhir }}</td>
                <td>
                    <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editTahunModal-{{ $t->id }}">
                    <i class="mdi mdi-pencil"></i>
                    </a>
                    <form action="{{ route('admin.tahun.delete', $t->id) }}" method="POST" class="d-inline-block form-delete"
                    data-nama="tahun ajaran {{ $t->tahun_awal }}/{{ $t->tahun_akhir }}">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                    </form>
                </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- modal create -->
<div class="modal fade" id="createTahunModal" tabindex="-1" role="dialog" aria-labelledby="createTahunModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.tahun.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createTahunModalLabel">Tambah Tahun Ajaran</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                        <input type="text" class="form-control yearpicker" id="tahun_mulai" name="tahun_awal" value="<?= date('Y'); ?>" placeholder="Pilih tahun mulai">
                    </div>

                    <div class="form-group">
                      <label for="tahun_akhir" class="form-label">Tahun Akhir</label>
                      <input type="text" class="form-control yearpicker" id="tahun_akhir" name="tahun_akhir" value="<?= date('Y') + 1; ?>" placeholder="Pilih tahun akhir" readonly>
                      <small class="form-text text-danger">* Jangan diubah tahun akhir nya</small>
                    </div>

                </div>
               <div class="modal-footer w-100">
                <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                    <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                    <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                    </div>
                </div>
                </div>
            </div>
        </form>
    </div>
</div>


@foreach ($tahun as $t)
<!-- modal update -->
<div class="modal fade" id="editTahunModal-{{ $t->id }}" tabindex="-1" role="dialog" aria-labelledby="editTahunModalLabel-{{ $t->id }}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.tahun.update', $t->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editGuruModalLabel-{{ $t->id }}">Edit Tahun Ajaran</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <input type="hidden" name="id" value="{{ $t->id }}">

                    <div class="form-group">
                        <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                        <input type="text" class="form-control yearpickers" id="tahun_mulais" name="tahun_awal" value="{{ $t->tahun_awal }}">
                    </div>

                    <div class="form-group">
                        <label for="tahun_akhir" class="form-label">Tahun Akhir</label>
                        <input type="text" class="form-control yearpickers" id="tahun_akhirs" name="tahun_akhir" value="{{ $t->tahun_akhir }}" readonly>
                        <small class="form-text text-danger">* Jangan diubah tahun akhir nya</small>
                    </div>

                </div>
                 <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                    </div>
                  </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach

<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var item = row.querySelector('.tahun').textContent.toLowerCase();
            if (item.indexOf(searchValue) > -1) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus ?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>


<script>
  $('.yearpicker').datepicker({
    format: "yyyy",
    viewMode: "years",
    minViewMode: "years",
    autoclose: true
  });

  // Script untuk mengisi otomatis tahun akhir
  $('#tahun_mulai').on('change', function () {
    var tahunAwal = parseInt($(this).val());
    if (!isNaN(tahunAwal)) {
      var tahunAkhir = tahunAwal + 1;
      $('#tahun_akhir').val(tahunAkhir);
    }
  });
</script>

<script>
  $('.yearpickers').datepicker({
    format: "yyyy",
    viewMode: "years",
    minViewMode: "years",
    autoclose: true
  });

  $('#tahun_mulais').on('change', function () {
    var tahunAwal = parseInt($(this).val());
    if (!isNaN(tahunAwal)) {
      var tahunAkhir = tahunAwal + 1;
      $('#tahun_akhirs').val(tahunAkhir);
    }
  });
</script>

@endsection