@extends('backend.layout.template_bk')
@section('content')

<!-- Pastikan jQuery & Select2 CSS sudah di-include -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
.select2-container .select2-selection--single {
    height: 50px;
    padding: 10px;
    font-size: 16px;
    display: flex;
    align-items: center;
    border-radius: 5px;
    transition: all 0.3s ease;
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: normal;
    padding-left: 15px;
}
.select2-container--default .select2-selection--single:focus,
.select2-container--default .select2-selection--single:hover {
    border-color: #007bff;
}
.select2-dropdown {
    border-radius: 3px;
    border: 1px solid #007bff;
}
.select2-container--default .select2-selection--multiple {
    min-height: 50px;
    padding: 10px;
    font-size: 16px;
    border-radius: 5px;
}
</style>

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">BULAN KEHADIRAN</h4>
      <!-- Form Tambah Bulan Kehadiran -->
      <div class="row mb-4">
        <div class="col-12">
          <form action="{{ route('bk.bulan-kehadiran.store') }}" method="POST">
            @csrf

            <div class="form-row">
              <!-- 1) Multi-select Kelas -->
              <div class="form-group col-12 col-md-5">
                <label for="kelas_id" class="sr-only">Pilih Kelas</label>
                <select name="kelas_id[]" id="kelas_id" class="form-control select2" multiple required>
                  @foreach($kelasList as $kelas)
                    <option value="{{ $kelas->id }}">
                      {{ $kelas->nama }} - Semester {{ $kelas->semester->semester }} -
                      {{ $kelas->tahunAjaran->tahun_awal }}/{{ $kelas->tahunAjaran->tahun_akhir }}
                    </option>
                  @endforeach
                </select>
              </div>

              <!-- 2) Input Nama Bulan -->
              <div class="form-group col-12 col-md-4">
                <label for="bulan" class="sr-only">Nama Bulan</label>
                <input
                  type="month"
                  name="bulan"
                  id="bulan"
                  class="form-control"
                  style="height: 50px;"
                  value="{{ now()->format('Y-m') }}"
                  required
                >
              </div>

              <!-- 3) Button Kirim -->
              <div class="form-group col-12 col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100" style="height: 50px;">
                  Tambah
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>

      <!-- Daftar Bulan Kehadiran -->
      <div class="table-responsive">
        <table class="table table-striped text-center">
          <thead>
            <tr>
              <th>No</th>
              <th>Kelas</th>
              <th>Bulan</th>
              <th>Wali Kelas</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @forelse($bulanList as $i => $bulan)
              <tr>
                <td>{{ $loop->iteration }}</td>
                <td>
                    {{ $bulan->kelas->nama }} - semester {{ $bulan->kelas->semester->semester }} - {{ $bulan->kelas->tahunAjaran->tahun_awal }}/{{ $bulan->kelas->tahunAjaran->tahun_akhir }}
                </td>
                <td>{{ \Carbon\Carbon::parse($bulan->bulan)->translatedFormat('F Y') }}</td>
                <td>{{ $bulan->kelas->waliKelas->guru->user->name }}</td>
                <td>
                  <form action="{{ route('bk.bulan-kehadiran.delete', $bulan->id) }}" 
                    method="POST" 
                    class="d-inline-block form-delete"
                    title="Hapus"
                    data-nama="Data kehadiran kelas {{ $bulan->kelas->nama }} 
                    semester {{ $bulan->kelas->semester->semester }} 
                    {{ $bulan->kelas->tahunAjaran->tahun_awal }}/{{ $bulan->kelas->tahunAjaran->tahun_akhir }} ini akan dihapus!">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm">
                      <i class="mdi mdi-delete-forever"></i>
                    </button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="4">Belum ada bulan kehadiran.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>

<!-- Select2 JS (setelah jQuery) -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
  $(document).ready(function() {
    $('#kelas_id').select2({
      placeholder: '-- Pilih Kelas --',
      width: '100%'
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus ?',
          text: `${nama}`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

</script>

@if ($errors->has('duplicate'))
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first("duplicate") }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    </script>
@endif

@endsection
