@extends('backend.layout.template_guru')
@section('content')

@php
  date_default_timezone_set('Asia/Jakarta');
  $hour = date('H');
  if ($hour >= 5 && $hour < 11) {
    $greeting = 'Selamat pagi';
  } elseif ($hour >= 11 && $hour < 15) {
    $greeting = 'Selamat siang';
  } elseif ($hour >= 15 && $hour < 18) {
    $greeting = 'Selamat sore';
  } else {
    $greeting = 'Selamat malam';
  }
@endphp

<h3 style="margin-bottom: 30px">Selamat datang di halaman guru </h3>

{{-- Alert Bootstrap --}}
<div class="alert alert-success shadow-sm mb-5">
  <h5>{{ $greeting }}, {{ $user->name }}!</h5>
  <p>Semangat menjalankan tugas hari ini!</p>
</div>

<div class="row mt-4">
  <div class="col-md-6 col-lg-4">
    <div class="card shadow-sm border-left-primary">
      <div class="card-body text-center">
        <h5 class="card-title">Total Kelas yang Diampu</h5>
        <h2 class="fw-bold text-primary">{{ $totalKelas }}</h2>
      </div>
    </div>
  </div>
</div>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
<!-- SweetAlert -->
<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: 'Selamat datang {{ Auth::user()->name }} di halaman guru',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

</script>

@endsection
