@extends('backend.layout.template_guru')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="row d-flex justify-content-between">
        <div class="col-12 col-sm-6 col-md-3 mb-2">
          <h4 class="card-title w-100 w-lg-auto">LAYANAN KONSELING</h4>
        </div>
      </div>
      <div class="table-responsive">
        <table class="table table-striped text-center">
          <thead>
            <tr>
              <th>No</th>
              <th>Tanggal</th>
              <th>Status</th>
              <th>Murid</th>
              <th>NISN</th>
              <th>Jam</th>
              <th>Hari</th>
              <th>Keterangan</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach($layanans as $layanan)
            <tr>
              <td>{{ $loop->iteration }}</td>
              <td>
                {{ \Carbon\Carbon::parse($layanan->tanggal)->translatedFormat('d F Y') }}
              </td>
              <td>
                <div class="badge badge-{{ 
                  $layanan->status === 'Disetujui' ? 'success' :
                  ($layanan->status === 'Diproses' ? 'warning' :
                  ($layanan->status === 'Ditolak' ? 'danger' :
                  ($layanan->status === 'Selesai' ? 'dark' : 'info')))
                }}">
                  {{ $layanan->status }}
                </div>
              </td>
              <td>{{ $layanan->siswa->user->name ?? '-' }}</td>
              <td>{{ $layanan->siswa->nisn ?? '-' }}</td>
              <td>{{ $layanan->jadwal->jam }}</td>
              <td>{{ $layanan->jadwal->hari }}</td>
              <td>{{ $layanan->keterangan }}</td>
              <td>
                <button type="button" class="btn btn-warning btn-sm text-white" title="Edit Status"
                        data-toggle="modal" data-target="#ModalLayanan{{ $layanan->id }}">
                  <i class="mdi mdi-pencil"></i>
                </button>
                @if ($layanan->status === 'Selesai' && ! $layanan->sudah_ada_parenting)
                  <button type="button" class="btn btn-primary btn-sm text-white" title="Hasil Layanan"
                          data-toggle="modal" data-target="#HasilLayanan{{ $layanan->id }}">
                    <i class="mdi mdi-library-plus"></i>
                  </button>
                @endif
              </td>
            </tr>

            <!-- Modal Edit Status -->
            <div class="modal fade" id="ModalLayanan{{ $layanan->id }}" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-md modal-dialog-centered">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">Edit Layanan</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                  </div>
                  <form action="{{ route('guru.layanan.update', $layanan->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="modal-body">
                      <div class="form-group">
                        <label>Status</label>
                        <select name="status" class="form-control text-dark">
                          <option value="Diproses" {{ $layanan->status == 'Diproses' ? 'selected' : '' }}>Diproses</option>
                          <option value="Disetujui" {{ $layanan->status == 'Disetujui' ? 'selected' : '' }}>Disetujui</option>
                          <option value="Selesai" {{ $layanan->status == 'Selesai' ? 'selected' : '' }}>Selesai</option>
                          <option value="Ditolak" {{ $layanan->status == 'Ditolak' ? 'selected' : '' }}>Ditolak</option>
                        </select>
                      </div>
                      <div class="modal-footer w-100">
                        <div class="row w-100 d-flex justify-content-between">
                          <div class="col-12 col-lg-auto mb-2">
                            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                          </div>
                          <div class="col-12 col-lg-auto mb-2">
                            <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>

            <!-- Modal Hasil Layanan -->
            <div class="modal fade" id="HasilLayanan{{ $layanan->id }}" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-md modal-dialog-centered">
                <div class="modal-content">
                  <form action="{{ route('guru.hasilLayanan.store') }}" method="POST">
                    @csrf
                    <input type="hidden" name="siswa_id" value="{{ $layanan->siswa->siswa_id }}">
                    <input type="hidden" name="tanggal" value="{{ $layanan->tanggal }}">
                    <input type="hidden" name="permasalahan" value="{{ $layanan->keterangan }}">
                    <input type="hidden" name="tipe" value="0">
                    <input type="hidden" name="guru_id" value="{{ Auth::id() }}">

                    <div class="modal-header">
                      <h5 class="modal-title">Hasil Layanan Siswa</h5>
                      <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>

                    <div class="modal-body">
                      <div class="d-flex flex-column flex-md-row justify-content-md-between">
                        <p class="mb-1 fw-bold">
                          <strong> Nama : </strong> 
                          <span class="text-danger">{{ $layanan->siswa->user->name }}</span>
                        </p>
                        <p class="mb-1 text-md-end fw-bold">
                          <strong> Tanggal Layanan : </strong> 
                          <span class="text-danger">
                            {{ \Carbon\Carbon::parse($layanan->tanggal)->translatedFormat('d F Y') }}
                          </span>
                        </p>
                      </div>
                      <hr>
                      <div class="form-group">
                        <label>Permasalahan</label>
                        <textarea class="form-control" rows="3" required readonly>{{ $layanan->keterangan }}</textarea>
                      </div>

                      <div class="form-group">
                        <label>Penyelesaian</label>
                        <textarea name="penyelesaian" class="form-control" rows="3" required></textarea>
                      </div>
                      <div class="form-group">
                        <label>Hasil</label>
                        <textarea name="hasil" class="form-control" rows="3" required></textarea>
                      </div>
                    </div>
                      <div class="modal-footer w-100">
                        <div class="row w-100 d-flex justify-content-between">
                          <div class="col-12 col-lg-auto mb-2">
                            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                          </div>
                          <div class="col-12 col-lg-auto mb-2">
                            <button type="submit" class="btn btn-primary w-100 w-lg-auto">Kirim</button>
                          </div>
                        </div>
                      </div>
                  </form>
                </div>
              </div>
            </div>

            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>

<!-- SweetAlert -->
<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '{{ session('success') }}',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

</script>

@endsection
