@extends('backend.layout.template_kepsek')
@section('content')

@php
  date_default_timezone_set('Asia/Jakarta');
  $hour = date('H');
  if ($hour >= 5 && $hour < 11) {
    $greeting = 'Selamat pagi';
  } elseif ($hour >= 11 && $hour < 15) {
    $greeting = 'Selamat siang';
  } elseif ($hour >= 15 && $hour < 18) {
    $greeting = 'Selamat sore';
  } else {
    $greeting = 'Selamat malam';
  }
@endphp

<h4 class="mb-4">Selamat Datang di halaman kepala sekolah</h4>

<div class="alert alert-success shadow-sm mb-5">
  <h5>{{ $greeting }}, {{ Auth::user()->name }}!</h5>
  <p>Semangat menjalankan tugas hari ini!</p>
</div>

  <!-- LAYANAN KONSELING -->
  <div class="col-lg-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">
          <div class="mb-2">
            <small class="text-muted d-block text-center">Kelas dengan jumlah alpha terbanyak di bulan 
            <strong style="font-weight: bold;" class="text-danger">
  {{ \Carbon\Carbon::parse($latestBulan)->isoFormat('MMMM YYYY') }}
</strong>
          </div>
          <hr>
        </h4>
        <div class="table-responsive">
          <table class="table table-striped text-center">
            <thead>
              <tr>
                <th>Kelas</th>
                <th>Wali Kelas</th>
                <th>Total Alpha</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>{{ $top->kelas->nama }}
                - {{ $top->kelas->tahunAjaran->tahun_awal }} / {{ $top->kelas->tahunAjaran->tahun_akhir }}</td>
                <td>{{ $top->kelas->waliKelas->name }}</td>
                <td>{{ $top->total_alpha }}</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
<!-- SweetAlert -->
<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '{{ session('success') }}',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

</script>

@endsection