@extends('backend.layout.template_kepsek')
@section('content')

<form method="GET" action="{{ route('backend.kepsek.kehadiran') }}">
  <div class="row gy-3 mb-4">
    <!-- Select Kelas dengan Select2 -->
    <div class="col-12 col-md-7">
      <label for="kelas-select">Pilih Kelas:</label>
      <small class="form-text text-muted mb-1">Pilih satu kelas atau lebih</small>
      <select name="kelas_ids[]" id="kelas-select"
              class="form-control select2" multiple required>
        @foreach($kelasOptions as $group)
          <optgroup label="{{ $group['nama'] }}">
            @foreach($group['semesters'] as $s)
              <option value="{{ $s['id'] }}" {{ in_array($s['id'], $selected) ? 'selected' : '' }}>
                {{ $s['label'] }}
              </option>
            @endforeach
          </optgroup>
        @endforeach
      </select>
    </div>

    <!-- Tombol Select All -->
    <div class="col-12 col-md-1 d-flex align-items-end">
      <button type="button" class="btn btn-outline-secondary btn-sm w-100" id="kelas-select-all"
              title="Pilih Semua Kelas">
        <i class="bi bi-check2-all"></i>
      </button>
    </div>

    <!-- Tombol Tampilkan -->
    <div class="col-12 col-md-4 d-flex align-items-end">
      <button class="btn btn-primary w-100">Tampilkan</button>
    </div>
  </div>
</form>


@if($kelases->isEmpty())
  @if(count($selected) > 0)
    <div class="alert alert-warning">Tidak ada data untuk kelas terpilih.</div>
  @endif
@else
  {{-- Urutkan kelas berdasarkan semester terbaru --}}
  @foreach($kelases->sortByDesc(fn($k) => $k->semester->semester) as $kelas)
    @php
      // Group per bulan, urut bulan terbaru di atas
      $groupedBulan = $kelas->bulanKehadiran
                        ->groupBy(fn($b) => $b->bulan)
                        ->sortKeysDesc();
    @endphp

    <div class="col-lg-12 grid-margin stretch-card mb-4">
      <div class="card">
        <div class="card-body">
          {{-- Header Info --}}
          <div class="row mb-3">
            <div class="col-md-4 d-flex align-items-center">
              <h4 class="card-title mb-0">REKAP KEHADIRAN</h4>
            </div>
            <div class="col-md-4 d-flex align-items-center">
              <code class="w-100" style="font-weight: bold;">
               <span class="text-dark">Wali Kelas :</span> {{ $kelas->waliKelas->name ?? '-' }}
              </code>
            </div>
            <div class="col-md-4 d-flex align-items-center mt-1">
              <code class="w-100" style="font-weight: bold;">
                Kelas {{ $kelas->nama }} - Semester {{ $kelas->semester->semester }} - 
                {{ $kelas->tahunAjaran->tahun_awal }}/{{ $kelas->tahunAjaran->tahun_akhir }}
              </code>
            </div>
          </div>

          {{-- Jika tidak ada bulan data --}}
          @if($groupedBulan->isEmpty())
            <div class="alert alert-warning">Belum ada data kehadiran untuk kelas ini.</div>
          @else
            @foreach($groupedBulan as $bulanKey => $entries)
              @php
                $bulanLabel = \Carbon\Carbon::parse($bulanKey)->translatedFormat('F Y');
                // Kumpulkan semua kehadiran siswa di bulan ini
                $attendances = $entries->flatMap->kehadiranSiswa;
                $sakitTot = $attendances->sum('sakit');
                $izinTot  = $attendances->sum('izin');
                $alphaTot = $attendances->sum('alpha');
              @endphp

              <hr class="my-3" style="border-top: 2px dashed #ccc;" />

              @php $modalId = 'detailModal-' . $kelas->id . '-' . $loop->index; @endphp

              <div class="d-flex justify-content-between mb-2">
                <h5 class="text-dark">Bulan: <strong class="text-primary">{{ $bulanLabel }}</strong></h5>
                <button class="btn btn-sm btn-dark" data-toggle="modal" data-target="#{{ $modalId }}">
                    Detail Siswa
                </button>
              </div>

              <div class="table-responsive mb-4">
                <table class="table table-striped text-center">
                  <thead>
                    <tr>
                      <th>Sakit</th>
                      <th>Izin</th>
                      <th>Alpha</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>{!! $sakitTot > 0 
                          ? $sakitTot 
                          : '<span class="text-success fw-bold">Tidak ada</span>' !!}</td>
                      <td>{!! $izinTot > 0 
                          ? $izinTot 
                          : '<span class="text-success fw-bold">Tidak ada</span>' !!}</td>
                      <td>{!! $alphaTot > 0 
                          ? $alphaTot 
                          : '<span class="text-success fw-bold">Tidak ada</span>' !!}</td>
                    </tr>
                  </tbody>
                </table>
              </div>

            {{-- Modal Detail --}}


            <div class="modal fade" id="{{ $modalId }}" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detail Kehadiran</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <div class="d-flex flex-column flex-md-row justify-content-md-between mb-3">
          <p class="mb-1 fw-bold">
            <strong> Kelas : </strong> 
            <span class="text-danger">
              {{ $kelas->nama }} - Semester {{ $kelas->semester->semester }}
              ({{ $kelas->tahunAjaran->tahun_awal }}/{{ $kelas->tahunAjaran->tahun_akhir }})
            </span>
          </p>
          <p class="mb-1 text-md-end fw-bold">
            <strong> Bulan : </strong> 
            <span class="text-danger">{{ $bulanLabel }}</span>
          </p>
        </div>

        <table class="table table-striped text-center">
          <thead>
            <tr>
              <th>NISN</th>
              <th>Nama</th>
              <th>Sakit</th>
              <th>Izin</th>
              <th>Alpha</th>
            </tr>
          </thead>
          <tbody>
            @forelse($attendances as $ks)
              @php
                $user = $ks->siswa;
                $siswa = $user->siswa;
              @endphp
              <tr>
                <td>{{ $siswa->nisn ?? '-' }}</td>
                <td>{{ $user->name }}</td>
                <td>{!! $ks->sakit > 0 
                    ? $ks->sakit 
                    : '<span class="text-success fw-bold">Tidak ada</span>' !!}</td>
                <td>{!! $ks->izin > 0 
                    ? $ks->izin 
                    : '<span class="text-success fw-bold">Tidak ada</span>' !!}</td>
                <td>{!! $ks->alpha > 0 
                    ? $ks->alpha 
                    : '<span class="text-success fw-bold">Tidak ada</span>' !!}</td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center text-muted">Tidak ada data siswa.</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

              
            @endforeach
          @endif

        </div>
      </div>
    </div>
  @endforeach
@endif

@push('styles')
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <style>
    .select2-container--default .select2-selection--multiple {
      min-height: 50px;
      padding: 8px;
      font-size: 16px;
      border-radius: 5px;
      border: 1px solid #ced4da;
    }
    .select2-container--default .select2-selection--single {
      min-height: 50px;
      padding: 8px;
      font-size: 16px;
      border-radius: 5px;
      border: 1px solid #ced4da;
    }
  </style>
@endpush

@push('scripts')
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script>
    $(document).ready(function () {
      $('.select2').select2({
        placeholder: '-- Pilih Kelas --',
        allowClear: true,
        width: '100%'
      });

      // Select All Kelas
      $('#kelas-select-all').click(function () {
        $('#kelas-select option').prop('selected', true);
        $('#kelas-select').trigger('change');
      });
    });
  </script>
@endpush


@endsection
