@extends('backend.layout.template_kepsek')

@section('title','Filter Nilai Kelas')

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="card shadow-sm">
            <div class="card-body">
                <h4 class="card-title mb-4">Cari Nilai Kelas</h4>
                <form action="{{ route('cari_nilai_kelas') }}" method="POST">
                    @csrf
                    <div class="form-row">
  <!-- 1) Select Kelas -->
  <div class="form-group col-12 col-md-4">
    <label for="kelas-select">Pilih Kelas</label>
    <small class="form-text text-muted mb-1">Pilih satu kelas atau lebih</small>
    <select name="kelas_ids[]" id="kelas-select"
            class="form-control select2"
            multiple required>
      @foreach($kelasOptions as $kelasOption)
        <optgroup label="{{ $kelasOption['nama'] }}">
          @foreach($kelasOption['semesters'] as $semester)
            <option value="{{ $semester['id'] }}"
              {{ in_array($semester['id'], $selectedKelasIds ?? []) ? 'selected' : '' }}>
              {{ $semester['label'] }}
            </option>
          @endforeach
        </optgroup>
      @endforeach
    </select>
  </div>

  <!-- 2) Tombol Select All Kelas -->
  <div class="form-group col-12 col-md-1 d-flex align-items-end">
    <button type="button" class="btn btn-outline-secondary btn-block btn-sm"
            id="kelas-select-all" title="Pilih Semua Kelas">
      <i class="bi bi-check2-all"></i>
    </button>
  </div>

  <!-- 3) Select Mapel -->
  <div class="form-group col-12 col-md-4">
    <label for="mapel-select">Pilih Mapel (Opsional)</label>
    <small class="form-text text-muted mb-1">Kosongkan untuk melihat semua mapel</small>
    <select name="mapel_ids[]" id="mapel-select"
            class="form-control select2"
            multiple>
      @foreach($mapelOptions as $mapel)
        <option value="{{ $mapel->id }}"
          {{ in_array($mapel->id, $selectedMapelIds ?? []) ? 'selected' : '' }}>
          {{ $mapel->nama }}
        </option>
      @endforeach
    </select>
  </div>

  <!-- 4) Tombol Cari -->
  <div class="form-group col-12 col-md-3 d-flex align-items-end">
    <button type="submit" class="btn btn-primary btn-block">
      <i class="bi bi-search"></i> Cari
    </button>
  </div>
</div>

                </form>
            </div>
        </div>
    </div>
</div>

<!-- Jika ada data hasil filter, tampilkan di bawah -->
@if(isset($selectedData))
    @if($selectedData->count())
        @foreach($selectedData as $data)
            <div class="row mt-4">
                <div class="col-lg-12">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title">
                                KELAS <strong class="text-danger">{{ $data['kelas']->nama }}</strong>
                            </h5>
                            <p class="text-danger mb-3" style="font-weight: bold;">
                                Semester {{ $data['kelas']->semester->semester }} —
                                {{ $data['kelas']->tahunAjaran->tahun_awal }}/{{ $data['kelas']->tahunAjaran->tahun_akhir }}
                            </p>
                            <div class="table-responsive">
                                <table class="table table-striped text-center mb-0">
                                    <thead>
                                        <tr>
                                            <th>Mata Pelajaran</th>
                                            <th>Pengajar</th>
                                            <th>NIP</th>
                                            <th>Rencana Sumatif</th>
                                            <th>Sumatif Terlaksana</th>
                                            <th>Rata-Rata</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($data['mapel_data'] as $mapel)
                                            <tr>
                                                <td>{{ $mapel['mapel_nama'] }}</td>
                                                <td>{{ $mapel['pengajar_nama'] }}</td>
                                                <td>{{ $mapel['pengajar_nip'] }}</td>
                                                <td><span class="badge badge-info">{{ $mapel['rencana_sumatif'] }}</span></td>
                                                <td><span class="badge badge-success">{{ $mapel['sumatif_terlaksana'] }}</span></td>
                                                <td>
                                                    <strong class="{{ is_numeric($mapel['rata_rata']) ? 'text-dark' : 'text-danger' }}">
                                                        {{ is_numeric($mapel['rata_rata']) ? number_format($mapel['rata_rata'],0) : 'belum ada nilai' }}
                                                    </strong>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6" class="text-muted">Tidak ada mapel.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @else
        <div class="row mt-4">
            <div class="col-lg-12">
                <div class="alert alert-warning text-center">
                    <h5>Tidak ada data ditemukan</h5>
                    <p>Silakan periksa kembali filter yang dipilih</p>
                </div>
            </div>
        </div>
    @endif
@endif
@endsection

@push('styles')
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
      /* styling container Select2 */
      .select2-container--default .select2-selection--multiple {
        min-height: 50px;
        padding: 8px;
        font-size: 16px;
        border-radius: 5px;
        border: 1px solid #ced4da;
      }
      .select2-container--default .select2-selection--single {
        min-height: 50px;
        padding: 8px;
        font-size: 16px;
        border-radius: 5px;
        border: 1px solid #ced4da;
      }
      .select2-container--default .select2-selection--single:focus,
      .select2-container--default .select2-selection--single:hover {
        border-color: #007bff;
      }
      .select2-dropdown {
        border-radius: 5px;
        border: 1px solid #007bff;
      }
    </style>
@endpush

@push('scripts')
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
      $(document).ready(function() {
        // Initialize all selects with class .select2
        $('.select2').select2({
          placeholder: '-- Pilih --',
          allowClear: true,
          width: '100%'
        });
        // tombol select all / clear untuk kelas
        $('#kelas-select-all').click(function(){
          $('#kelas-select option').prop('selected', true);
          $('#kelas-select').trigger('change');
        });
        $('#kelas-clear').click(function(){
          $('#kelas-select option').prop('selected', false);
          $('#kelas-select').trigger('change');
        });
        // tombol select all / clear untuk mapel
        $('#mapel-select-all').click(function(){
          $('#mapel-select option').prop('selected', true);
          $('#mapel-select').trigger('change');
        });
        $('#mapel-clear').click(function(){
          $('#mapel-select option').prop('selected', false);
          $('#mapel-select').trigger('change');
        });
      });
    </script>
@endpush
