@extends('backend.layout.template_siswa')
@section('content')

@php
  date_default_timezone_set('Asia/Jakarta');
  $hour = date('H');
  if ($hour >= 5 && $hour < 11) {
    $greeting = 'Selamat pagi';
  } elseif ($hour >= 11 && $hour < 15) {
    $greeting = 'Selamat siang';
  } elseif ($hour >= 15 && $hour < 18) {
    $greeting = 'Selamat sore';
  } else {
    $greeting = 'Selamat malam';
  }
@endphp


<div class="alert alert-success shadow-sm mb-4">
  <h5>{{ $greeting }}, {{ Auth::user()->name }}!</h5>
  <p>Selamat datang di halaman siswa</p>
</div>

<h4 class="mb-4 text-uppercase">Data kehadiran dan nilai </h4>

@if ($kelases->count())
  @foreach ($kelases as $kelas)
    <div class="card mb-4 shadow-sm">
      <div class="card-body">
        <p class="card-description mb-3">
          <code class="ms-2 fw-bold d-flex justify-content-center" style="font-weight: bold;">
            Kelas {{ $kelas->nama }} 
            - Semester {{ $kelas->semester->semester }} 
            - {{ $kelas->tahunAjaran->tahun_awal }}/{{ $kelas->tahunAjaran->tahun_akhir }}
          </code>
        </p>
        <hr>
        @php
  $rekap = $kehadiranPerKelas[$kelas->id] ?? null;
@endphp

@if ($rekap)
  <div class="table-responsive">
    <table class="table table-striped">
      <thead>
        <tr class="text-center">
          <th>Sakit</th>
          <th>Izin</th>
          <th>Alpha</th>
        </tr>
      </thead>
      <tbody>
        <tr class="text-center">
          <td>{{ $rekap['sakit'] }}</td>
          <td>{{ $rekap['izin'] }}</td>
          <td>{{ $rekap['alpha'] }}</td>
        </tr>
      </tbody>
    </table>
  </div>
@else
  <div class="alert alert-warning text-center">
    Belum ada bulan kehadiran di kelas ini.
  </div>
@endif

        <br>
        <hr>

        <div class="table-responsive">
          <table class="table table-striped">
  <thead>
    <tr class="text-center">
      <th>Pengajar</th>
      <th>Mata Pelajaran</th>
      <th>Nilai Rata-rata</th>
      <th>Total Sumatif</th>
    </tr>
  </thead>
  <tbody>
    @php $siswaId = $siswa->siswa_id; @endphp
    @foreach($kelas->kelasMapel as $km)
      @if($km->mapel->tipe)
        @php
          $nilai = $km->nilai->firstWhere('siswa_id', $siswaId);
          $arr = is_string($nilai?->s_nilai)
                  ? json_decode($nilai->s_nilai, true)
                  : ($nilai?->s_nilai ?? []);

          $jumlahFieldPenilaian = count(array_keys($arr));
          $isi = array_filter($arr, fn($v) => $v !== null);
          $jumlahPenilaian = count($isi);
          $avg = $jumlahPenilaian ? round(array_sum($isi) / $jumlahPenilaian) : null;

          $color = is_numeric($avg) ? 'black' : '#dc3545';
        @endphp
        <tr class="text-center">
          <td>{{ $km->guru->user->name ?? '-' }}</td>
          <td>{{ $km->mapel->nama }}</td>
          <td style="color: {{ $color }}">
            @if($avg !== null)
              {{ $avg }} <span class="text-muted">/ {{ $jumlahPenilaian }} penilaian</span>
            @else
              <span class="text-danger">belum ada nilai</span>
            @endif
          </td>
          <td>{{ $jumlahFieldPenilaian }}</td>
        </tr>
      @endif
    @endforeach
  </tbody>
</table>

        </div>
      </div>
    </div>
  @endforeach
@else
  <div class="alert alert-warning">Kamu belum memiliki data kehadiran dan nilai.</div>
@endif

@if (session('success'))
<script>
Swal.fire({
  icon: 'success',
  title: 'Berhasil Login',
  text: 'Selamat datang {{ Auth::user()->name }} di halaman siswa!',
  confirmButtonText: 'Lanjutkan',
  customClass: {
    popup: 'swal-popup-tall',
  }
});
</script>
@endif

<style>
.swal-popup-tall {
  height: 400px !important;
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

@endsection
