@extends('backend.layout.template_siswa')
@section('content')

@php
  $groupedKelas = $kehadiranSiswa->groupBy(function($item) {
    return $item->bulan->kelas->id;
  });
@endphp

@forelse($groupedKelas as $kelasId => $dataKelas)
  @php
    $kelas = $dataKelas->first()->bulan->kelas;
    $groupedBulan = $dataKelas->groupBy(fn($item) => $item->bulan->id);
  @endphp

  <div class="col-lg-12 grid-margin stretch-card mb-4">
    <div class="card">
      <div class="card-body">
        <div class="row mb-3">
          <div class="col-12 col-md-4 mb-2 d-flex align-items-center">
            <h4 class="card-title mb-0" style="font-size: 16px;">REKAP KEHADIRAN BULANAN</h4>
          </div>
          <div class="col-12 col-md-4 mb-2 d-flex align-items-center">
            <code class="w-100 text-md-center" style="font-weight: bold;">
              Kelas {{ $kelas->nama ?? '-' }} - Semester {{ $kelas->semester->semester }}
              - {{ $kelas->tahunAjaran->tahun_awal ?? '-' }}/{{ $kelas->tahunAjaran->tahun_akhir ?? '-' }}
            </code>
          </div>
          <div class="col-12 col-md-4 mb-2 d-flex align-items-center">
            <code class="w-100 text-md-center" style="font-weight: bold;">
               <span class="text-dark">Nama Siswa :</span> {{ auth()->user()->name ?? '-' }}
            </code>
        </div>

        </div>

        {{-- Loop Per Bulan --}}
        @foreach($groupedBulan as $bulanId => $entries)
          @php
            $bulanLabel = \Carbon\Carbon::parse($entries->first()->bulan->bulan)->translatedFormat('F Y');
          @endphp

          <hr class="my-3" style="border-top: 2px dashed #ccc;" />

          <div class="mb-2 d-flex justify-content-between">
            <h5 class="mb-1 text-dark">Bulan: <strong class="text-primary">{{ $bulanLabel }}</strong></h5>
          </div>

          <div class="table-responsive mb-4">
            <table class="table table-striped text-center">
              <thead>
                <tr>
                  <th>Sakit</th>
                  <th>Izin</th>
                  <th>Alpha</th>
                </tr>
              </thead>
              <tbody>
                @foreach($entries as $entry)
                  <tr>
                    <td>{{ $entry->sakit ?? 0 }}</td>
                    <td>{{ $entry->izin ?? 0 }}</td>
                    <td>{{ $entry->alpha ?? 0 }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        @endforeach

      </div>
    </div>
  </div>
@empty
  <div class="alert alert-warning">Belum ada data kehadiran.</div>
@endforelse

@endsection
