@extends('backend.layout.template_siswa')
@section('content')

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
.select2-container .select2-selection--single {
    height: 50px;
    padding: 10px;
    font-size: 16px;
    display: flex;
    align-items: center;
    border-radius: 5px;
    transition: all 0.3s ease;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: normal;
    padding-left: 20px;
}

.select2-container--default .select2-selection--single:focus,
.select2-container--default .select2-selection--single:hover {
    border-color: #007bff;
}

.select2-dropdown {
    border-radius: 3px;
    border: 1px solid #007bff;
}

.select2-container--default .select2-selection--single .select2-selection__clear {
    position: absolute;
    left: 10px;
    right: auto;
    top: 50%;
    transform: translateY(-50%);
    font-size: 20px;
    color: #dc3545;
    cursor: pointer;
}

</style>

<div class="row">
<div class="col-md-5 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Form Layanan Konseling</h4>
      <form action="{{ route('siswa.layanan.store') }}" method="POST">
        @csrf
        <div class="form-group">
          <select class="form-control" id="guruSelect" name="guru_id" required style="width: 100%;">
            <option value="" disabled selected>Pilih Guru</option>
            @foreach($gurus as $g)
              <option value="{{ $g->guru_id }}">{{ $g->user->name }} ({{ $g->nip }})</option>
            @endforeach
          </select>
        </div>
        <div class="form-group">
          <select class="form-control text-dark" id="hari" required>
            <option value="" selected hidden>Pilih hari</option>
          </select>
        </div>
        <div class="form-group">
          <select class="form-control text-dark" id="jam" name="jadwal_id" required>
            <option value="" selected hidden>Pilih jam</option>
          </select>
        </div>
        <div class="form-group">
          <textarea class="form-control" id="keterangan" name="keterangan" rows="2" placeholder="Isi permasalahan anda disini ..." required></textarea>
        </div>
        <div class="form-group">
          <small class="form-text text-danger">* Pilih tanggal sesuai hari yang anda pilih</small>
          <input type="date" class="form-control" id="tanggal" name="tanggal" required>
        </div>
        <div class="d-flex justify-content-between">
          <button type="reset" class="btn btn-danger" id="resetBtn">Batal</button>
          <button type="submit" class="btn btn-primary">Kirim</button>
        </div>
      </form>
      @if(session('wa_url'))
<script>
window.open("{{ session('wa_url') }}", '_blank');
</script>
@endif
    </div>
  </div>
</div>
<div class="col-md-7 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <p class="card-title mb-0">Data Layanan Konseling</p>
      <div class="table-responsive">
        <table class="table table-striped table-borderless">
          <thead>
            <tr class="text-center">  
              <th>No</th>
              <th>Tanggal</th>
              <th>Status</th>
              <th>Guru</th>
              <th>NIP</th>
              <th>Jam</th>
              <th>Hari</th>
              <th>Keterangan</th>
            </tr>  
          </thead>
          <tbody>
            @forelse($layanans as $l)
            <tr class="text-center">
              <td>{{ $loop->iteration }}</td>
              <td>
                {{ \Carbon\Carbon::parse($l->tanggal)->translatedFormat('d F Y') }}
              </td>
              <td>
                <div class="badge badge-{{
                  $l->status === 'Disetujui' ? 'success' : (
                  $l->status === 'Diproses' ? 'warning' : (
                  $l->status === 'Ditolak' ? 'danger' : 'dark'))
                }}">{{ $l->status }}</div>
              </td>
              <td>{{ $l->jadwal->guru->user->name ?? '-' }}</td>
              <td>{{ $l->jadwal->guru->nip ?? '-' }}</td>
              <td>{{ $l->jadwal->jam }}</td>
              <td>{{ $l->jadwal->hari }}</td>
              <td>{{ $l->keterangan }}</td>
            </tr>
            @empty
              <tr>
                <td colspan="8" class="text-center text-muted">Belum ada riwayat layanan konseling</td>
              </tr>
              @endforelse
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>        

<script>
$(document).ready(function() {
    $('#guruSelect').select2({
        placeholder: "Pilih Guru",
        allowClear: true,
        width: '100%'
    });

    let semuaJadwal = [];

    $('#guruSelect').on('change', function() {
        const guruId = $(this).val();
        $('#hari').html('<option value="" selected hidden>Pilih Hari</option>');
        $('#jam').html('<option value="" selected hidden>Pilih Jam</option>');
        semuaJadwal = [];

        if (!guruId) return;

        $.get(`/siswa/layanan/jadwal/${guruId}`, function(data) {
            // 'data' sekarang array objek: {id, hari, jam, unavailable}
            semuaJadwal = data;

            // Ambil list hari unik
            const hariUnik = [...new Set(data.map(item => item.hari))];

            hariUnik.forEach(hari => {
                $('#hari').append(`<option value="${hari}">${hari}</option>`);
            });
        });
    });

    $('#hari').on('change', function () {
        const selectedHari = $(this).val();
        $('#jam').html('<option value="" selected hidden>Pilih Jam</option>');

        const jamHariIni = semuaJadwal.filter(j => j.hari === selectedHari);
        jamHariIni.forEach(j => {
            if (j.unavailable) {
                $('#jam').append(`
                    <option value="" disabled>
                        ${j.jam} - Tidak tersedia
                    </option>
                `);
            } else {
                $('#jam').append(`
                    <option value="${j.id}">
                        ${j.jam}
                    </option>
                `);
            }
        });
    });

    $('#resetBtn').click(function() {
        $('#guruSelect').val(null).trigger('change');
        $('#hari').html('<option value="" hidden selected>Pilih Hari</option>');
        $('#jam').html('<option value="" hidden selected>Pilih Jam</option>');
        semuaJadwal = [];
    });
});
</script>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
<!-- SweetAlert -->
<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '{{ session('success') }}',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus ?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script><script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus ?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>


@endsection
