@extends('backend.layout.template_siswa')
@section('content')

<div class="row">
  <div class="col-md-5 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Form Layanan Parenting</h4>
        <form action="{{ route('siswa.parenting.store') }}" method="POST">
  @csrf

  <div class="modal-body">
                      <div class="d-flex flex-column flex-md-row justify-content-md-between">
                        <p class="mb-1 fw-bold">
                            <strong> Guru Bk : </strong> 
                            <span class="text-danger">{{ $guruBk->user->name }} ({{ $guruBk->nip }})</span>
                          </p>
                      </div>
                      <hr>
                      </div>

  <div class="form-group">
    <label for="permasalahan">Permasalahan</label>
    <textarea name="permasalahan" id="permasalahan" placeholder="Isi permasalahan anda disini ..." class="form-control" rows="5" required></textarea>
  </div>

  <div class="form-group">
    <label for="tanggal">Tanggal</label>
    <input type="date" name="tanggal" id="tanggal" value="{{ date('Y-m-d') }}" class="form-control" required>
  </div>

  <div class="d-flex justify-content-between">
    <button type="reset" class="btn btn-danger">Batal</button>
    <button type="submit" class="btn btn-primary">Kirim</button>
  </div>
</form>

      </div>
    </div>
  </div>

  <div class="col-md-7 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <p class="card-title mb-0">Data Layanan Parenting</p>
        <div class="table-responsive">
          <table class="table table-striped table-borderless">
            <thead class="text-center">
              <tr>
                <th>No</th>
                <th>Tanggal</th>
                <th>Permasalahan</th>
                <th>Penyelesaian</th>
              </tr>
            </thead>
            <tbody>
              @forelse($layanans as $l)
              <tr class="text-center">
                <td>{{ $loop->iteration }}</td>
                <td>
                  {{ \Carbon\Carbon::parse($l->tanggal)->translatedFormat('d F Y') }}
                </td>
                <td>{{ $l->permasalahan }}</td>
                <td style="color: {{ $l->penyelesaian ? 'black' : '#dc3545' }}">{{ $l->penyelesaian ?? 'Menunggu Jawaban' }}</td>
              </tr>
              @empty
              <tr>
                <td colspan="4" class="text-center text-muted">Belum ada riwayat layanan parenting.</td>
              </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>

@endsection
