@php
  $pendidikanList = ['Tidak sekolah', 'Putus SD', 'SD sederajat', 'SMP sederajat', 'SMA sederajat', 'D1', 'D2', 'D3', 'D4/S1', 'S2', 'S3'];
  $pekerjaanList = ['Tidak bekerja', 'Nelayan', 'Petani', 'Peternak', 'PNS/TNI/POLRI', 'Karyawan Swasta', 'Pedagang kecil', 'Pedagang besar', 'Wiraswasta', 'Wira usaha', 'Buruh', 'Pensiunan'];
  $penghasilanList = ['< Rp. 500.000', 'Rp. 500.000 - Rp. 999.0000', 'Rp. 1.000.000 - Rp. 1.999.0000', 'Rp. 2.000.000 - Rp. 4.999.000', 'Rp. 5.000.000 - Rp. 20.000.000', '> Rp. 20.000.000', 'Tidak berpenghasilan'];
@endphp

<h4 class="text-center font-weight-bold">Data Diri Ayah</h4>
<hr>
<div class="row">
  <div class="col-md-6 form-group">
    <label>Nama Ayah</label>
    <input type="text" name="data_ayah[nama_ayah]" value="{{ old('data_ayah.nama_ayah', $siswa->data_ayah['nama_ayah'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>NIK Ayah</label>
    <input type="text" name="data_ayah[nik_ayah]" value="{{ old('data_ayah.nik_ayah', $siswa->data_ayah['nik_ayah'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>Tahun Lahir Ayah</label>
    <input type="date" name="data_ayah[tahun_lahir]" value="{{ old('data_ayah.tahun_lahir', $siswa->data_ayah['tahun_lahir'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>Pendidikan Ayah</label>
    <select name="data_ayah[pendidikan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @php
        $pendidikanList = ['Tidak sekolah', 'Putus SD', 'SD sederajat', 'SMP sederajat', 'SMA sederajat', 'D1', 'D2', 'D3', 'D4/S1', 'S2', 'S3'];
      @endphp
      @foreach($pendidikanList as $p)
        <option value="{{ $p }}" {{ old('data_ayah.pendidikan', $siswa->data_ayah['pendidikan'] ?? '') == $p ? 'selected' : '' }}>{{ $p }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Pekerjaan Ayah</label>
    <select name="data_ayah[pekerjaan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @php
        $pekerjaanList = ['Tidak bekerja','Nelayan','Petani','Peternak','PNS/TNI/POLRI','Karyawan Swasta','Pedagang kecil','Pedagang besar','Wiraswasta','Wira usaha','Buruh','Pensiunan'];
      @endphp
      @foreach($pekerjaanList as $p)
        <option value="{{ $p }}" {{ old('data_ayah.pekerjaan', $siswa->data_ayah['pekerjaan'] ?? '') == $p ? 'selected' : '' }}>{{ $p }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Penghasilan Ayah per Bulan</label>
    <select name="data_ayah[penghasilan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @php
        $penghasilanList = [
          '< Rp. 500.000',
          'Rp. 500.000 - Rp. 999.000',
          'Rp. 1.000.000 - Rp. 1.999.000',
          'Rp. 2.000.000 - Rp. 4.999.000',
          'Rp. 5.000.000 - Rp. 20.000.000',
          '> Rp. 20.000.000',
          'Tidak berpenghasilan'
        ];
      @endphp
      @foreach($penghasilanList as $gaji)
        <option value="{{ $gaji }}" {{ old('data_ayah.penghasilan', $siswa->data_ayah['penghasilan'] ?? '') == $gaji ? 'selected' : '' }}>{{ $gaji }}</option>
      @endforeach
    </select>
  </div>

</div>
