<h4 class="text-center font-weight-bold">Data Diri Siswa</h4>
<hr>

<div class="row">

  {{-- Baris 1 --}}
  <div class="col-md-4 form-group">
    <label>Nama</label>
    <input type="text" name="name" value="{{ old('name', $siswa->user->name) }}" class="form-control"
      placeholder="Tulis dengan huruf kapital sesuai dengan ijasah SD" required>
  </div>
  <div class="col-md-4 form-group">
    <label>NISN</label>
    <input type="text" name="nisn" value="{{ old('nisn', $siswa->nisn) }}" class="form-control"
      placeholder="(Tuliskan NISN dengan akurat 10 angka)" required>
  </div>
  <div class="col-md-4 form-group">
    <label>NIPD</label>
    <input type="text" name="nipd" value="{{ old('nipd', $siswa->nipd) }}" class="form-control"
      placeholder="Nomor Induk Peserta Didik" required>
  </div>

  {{-- Baris 2 --}}
  <div class="col-md-4 form-group">
    <label>Email</label>
    <input type="email" name="email" value="{{ old('email', $siswa->user->email) }}" class="form-control"
      placeholder="abcd@gmail.com" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Jenis Kelamin</label>
    <select name="jenis_kelamin" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      <option value="L" {{ old('jenis_kelamin', $siswa->jenis_kelamin) == 'L' ? 'selected' : '' }}>Laki-laki</option>
      <option value="P" {{ old('jenis_kelamin', $siswa->jenis_kelamin) == 'P' ? 'selected' : '' }}>Perempuan</option>
    </select>
  </div>
  <div class="col-md-4 form-group">
    <label>Agama</label>
    <select name="agama" class="form-control text-dark" required>
      @foreach(['islam','kristen','katolik','hindu','buddha','konghucu','lainnya'] as $a)
      <option value="{{ $a }}" {{ old('agama', $siswa->agama) == $a ? 'selected' : '' }}>{{ ucfirst($a) }}</option>
      @endforeach
    </select>
  </div>

  {{-- Baris 3 --}}
  <div class="col-md-4 form-group">
    <label>Tempat Lahir</label>
    <input type="text" name="tempat_lahir" value="{{ old('tempat_lahir', $siswa->tempat_lahir) }}" class="form-control"
      required>
  </div>
  <div class="col-md-4 form-group">
    <label>Tanggal Lahir</label>
    <input type="date" name="tanggal_lahir" value="{{ old('tanggal_lahir', $siswa->tanggal_lahir) }}"
      class="form-control" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Sekolah Asal</label>
    <input type="text" name="sekolah_asal" value="{{ old('sekolah_asal', $siswa->sekolah_asal) }}"
      class="form-control" placeholder="(Sekolah Dasar)" required>
  </div>

  {{-- Baris 4 --}}
  <div class="col-md-4 form-group">
    <label>No HP</label>
    <input type="text" name="no_hp" value="{{ old('no_hp', $siswa->no_hp) }}" class="form-control" placeholder="(tulis dengan format +62xxxxxxxxxx)" required>
  </div>

  <div class="col-md-4 form-group">
    <label>No Telepon</label>
    <input type="text" name="no_telepon" value="{{ old('no_telepon', $siswa->no_telepon) }}" class="form-control" placeholder="(tulis dengan format +62xxxxxxxxxx)" required>
  </div>
  
  <div class="col-md-4 form-group">
    <label>Alamat</label>
    <input type="text" name="alamat" value="{{ old('alamat', $siswa->alamat) }}" class="form-control" required>
  </div>

  {{-- Baris 5 --}}
  <div class="col-md-4 form-group">
    <label>Jenis Tinggal</label>
    <select name="jenis_tinggal" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Bersama Ortu','Ikut Wali','Kos','Asrama','Panti Asuhan','Lainnya'] as $tt)
      <option value="{{ $tt }}" {{ old('jenis_tinggal', $siswa->jenis_tinggal) == $tt ? 'selected' : '' }}>{{ ucfirst($tt) }}</option>
      @endforeach
    </select>
  </div>
  <div class="col-md-4 form-group">
    <label>Berkebutuhan Khusus</label>
    <select name="berkebutuhan_khusus" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Tidak','Netra','Rungu','Grahita Ringan','Grahita Sedang','Daksa Ringan','Daksa Sedang','Laras','Wicara','Tuna Ganda','Hiper Aktif','Cerdas Istimewa','Bakat Istimewa','Kesulitan Belajar','Narkoba','Indigo','Down Sindrome','Autis'] as $b)
      <option value="{{ $b }}" {{ old('berkebutuhan_khusus', $siswa->berkebutuhan_khusus) == $b ? 'selected' : '' }}>{{ ucfirst($b) }}</option>
      @endforeach
    </select>
  </div>
  <div class="col-md-4 form-group">
    <label>Alat Transportasi</label>
    <select name="alat_transportasi" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih</option>
      @foreach(['Jalan Kaki', 'Sepeda', 'Antar Jemput', 'Kendaraan Umum'] as $t)
      <option value="{{ $t }}" {{ old('alat_transportasi', $siswa->alat_transportasi ?? '') == $t ? 'selected' : '' }}>{{ $t }}</option>
      @endforeach
    </select>
  </div>

  {{-- Baris 6 --}}
  <div class="col-md-4 form-group">
    <label>Anak Keberapa</label>
    <input type="number" name="anak_ke" value="{{ old('anak_ke', $siswa->anak_ke) }}" class="form-control" inputmode="numeric" pattern="[0-9]*" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Jumlah Saudara Kandung</label>
    <input type="number" name="jumlah_saudara_kandung" value="{{ old('jumlah_saudara_kandung', $siswa->jumlah_saudara_kandung) }}" class="form-control" inputmode="numeric" pattern="[0-9]*" required>
  </div>
  <div class="col-md-4 form-group">
    <label>Rombel Saat Ini</label>
    <input type="text" name="rombel_saat_ini" value="{{ old('rombel_saat_ini', $siswa->rombel_saat_ini) }}" class="form-control" placeholder="Contoh: VII A" required>
  </div>

</div>
