@php
  $pendidikanList = ['Tidak sekolah', 'Putus SD', 'SD sederajat', 'SMP sederajat', 'SMA sederajat', 'D1', 'D2', 'D3', 'D4/S1', 'S2', 'S3'];
  $pekerjaanList = ['Tidak bekerja', 'Nelayan', 'Petani', 'Peternak', 'PNS/TNI/POLRI', 'Karyawan Swasta', 'Pedagang kecil', 'Pedagang besar', 'Wiraswasta', 'Wira usaha', 'Buruh', 'Pensiunan'];
  $penghasilanList = ['< Rp. 500.000', 'Rp. 500.000 - Rp. 999.0000', 'Rp. 1.000.000 - Rp. 1.999.0000', 'Rp. 2.000.000 - Rp. 4.999.000', 'Rp. 5.000.000 - Rp. 20.000.000', '> Rp. 20.000.000', 'Tidak berpenghasilan'];
@endphp

<h4 class="text-center font-weight-bold mt-4">Data Diri Ibu</h4>
<hr>
<div class="row">
  <div class="col-md-6 form-group">
    <label>Nama Ibu</label>
    <input type="text" name="data_ibu[nama_ibu]" value="{{ old('data_ibu.nama_ibu', $siswa->data_ibu['nama_ibu'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>NIK Ibu</label>
    <input type="text" name="data_ibu[nik_ibu]" value="{{ old('data_ibu.nik_ibu', $siswa->data_ibu['nik_ibu'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>Tahun Lahir Ibu</label>
    <input type="date" name="data_ibu[tahun_lahir]" value="{{ old('data_ibu.tahun_lahir', $siswa->data_ibu['tahun_lahir'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>Pendidikan Ibu</label>
    <select name="data_ibu[pendidikan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @foreach($pendidikanList as $p)
        <option value="{{ $p }}" {{ old('data_ibu.pendidikan', $siswa->data_ibu['pendidikan'] ?? '') == $p ? 'selected' : '' }}>{{ $p }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Pekerjaan Ibu</label>
    <select name="data_ibu[pekerjaan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @foreach($pekerjaanList as $p)
        <option value="{{ $p }}" {{ old('data_ibu.pekerjaan', $siswa->data_ibu['pekerjaan'] ?? '') == $p ? 'selected' : '' }}>{{ $p }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Penghasilan Ibu per Bulan</label>
    <select name="data_ibu[penghasilan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @foreach($penghasilanList as $gaji)
        <option value="{{ $gaji }}" {{ old('data_ibu.penghasilan', $siswa->data_ibu['penghasilan'] ?? '') == $gaji ? 'selected' : '' }}>{{ $gaji }}</option>
      @endforeach
    </select>
  </div>
</div>
