@php
  $pendidikanList = ['Tidak sekolah', 'Putus SD', 'SD sederajat', 'SMP sederajat', 'SMA sederajat', 'D1', 'D2', 'D3', 'D4/S1', 'S2', 'S3'];
  $pekerjaanList = ['Tidak bekerja', 'Nelayan', 'Petani', 'Peternak', 'PNS/TNI/POLRI', 'Karyawan Swasta', 'Pedagang kecil', 'Pedagang besar', 'Wiraswasta', 'Wira usaha', 'Buruh', 'Pensiunan'];
  $penghasilanList = ['< Rp. 500.000', 'Rp. 500.000 - Rp. 999.0000', 'Rp. 1.000.000 - Rp. 1.999.0000', 'Rp. 2.000.000 - Rp. 4.999.000', 'Rp. 5.000.000 - Rp. 20.000.000', '> Rp. 20.000.000', 'Tidak berpenghasilan'];
@endphp

<h4 class="text-center font-weight-bold mt-4">Data Diri Wali</h4>
<hr>
<div class="row">
  <div class="col-md-6 form-group">
    <label>Nama Wali</label>
    <input type="text" name="data_wali[nama_wali]" value="{{ old('data_wali.nama_wali', $siswa->data_wali['nama_wali'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>NIK Wali</label>
    <input type="text" name="data_wali[nik_wali]" value="{{ old('data_wali.nik_wali', $siswa->data_wali['nik_wali'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>Tahun Lahir Wali</label>
    <input type="date" name="data_wali[tahun_lahir]" value="{{ old('data_wali.tahun_lahir', $siswa->data_wali['tahun_lahir'] ?? '') }}" class="form-control">
  </div>

  <div class="col-md-6 form-group">
    <label>Pendidikan Wali</label>
    <select name="data_wali[pendidikan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @foreach($pendidikanList as $p)
        <option value="{{ $p }}" {{ old('data_wali.pendidikan', $siswa->data_wali['pendidikan'] ?? '') == $p ? 'selected' : '' }}>{{ $p }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Pekerjaan Wali</label>
    <select name="data_wali[pekerjaan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @foreach($pekerjaanList as $p)
        <option value="{{ $p }}" {{ old('data_wali.pekerjaan', $siswa->data_wali['pekerjaan'] ?? '') == $p ? 'selected' : '' }}>{{ $p }}</option>
      @endforeach
    </select>
  </div>

  <div class="col-md-6 form-group">
    <label>Penghasilan Wali per Bulan</label>
    <select name="data_wali[penghasilan]" class="form-control text-dark">
      <option value="" selected hidden>Pilih</option>
      @foreach($penghasilanList as $gaji)
        <option value="{{ $gaji }}" {{ old('data_wali.penghasilan', $siswa->data_wali['penghasilan'] ?? '') == $gaji ? 'selected' : '' }}>{{ $gaji }}</option>
      @endforeach
    </select>
  </div>
</div>
