<?php

use App\Http\Controllers\GuruController;
use App\Http\Controllers\SiswaController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BkController;
use App\Http\Controllers\KepsekController;
use App\Http\Controllers\Admin\AdminController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/



Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::prefix('siswa')->middleware(['auth', 'is_siswa'])->group(function () {

    Route::get('/index', [SiswaController::class, 'index'])->name('backend.siswa.index');

    // Profil
    Route::get('/profil', [SiswaController::class, 'profil'])->name('backend.siswa.profil');
    Route::put('/profil/update/{id}', [SiswaController::class, 'updateSiswa'])->name('siswa.update');
    
    // Nilai
    Route::get('/nilai', [SiswaController::class, 'nilai'])->name('nilai');
    
    // Layanan
    Route::get('/layananKonseling', [SiswaController::class, 'layanan'])->name('siswa.layanan');
    Route::get('/layanan/jadwal/{guru_id}', [SiswaController::class, 'getJadwalGuru']);
    Route::post('/layanan', [SiswaController::class, 'storeLayanan'])->name('siswa.layanan.store');
    Route::get('/layananParenting', [SiswaController::class, 'layananParenting'])->name('siswa.parenting');
    Route::post('/layanan-parenting', [SiswaController::class, 'store'])->name('siswa.parenting.store');
    Route::get('/kehadiran', [SiswaController::class, 'kehadiran'])->name('backend.siswa.kehadiran');

});

Route::prefix('guru')->middleware(['auth', 'is_guru'])->group(function () {

    Route::get('/index', [GuruController::class, 'index'])->name('backend.guru.index');

    // Profil
    Route::get('/profil', [GuruController::class, 'profil'])->name('backend.guru.profil');

    // Penilaian
    Route::get('/penilaian', [GuruController::class, 'penilaian'])->name('backend.guru.penilaian');
    Route::post('/penilaian/update-jumlah-sumatif', [GuruController::class, 'updateJumlahSumatif'])->name('guru.penilaian.updateJumlahSumatif');
    Route::post('/penilaian/update-label-sumatif', [GuruController::class, 'updateLabelSumatif'])->name('guru.penilaian.updateLabelSumatif');
    Route::put('/penilaian/updateNilai',[GuruController::class, 'updateNilai'])->name('guru.penilaian.updateNilai');
    Route::get('/penilaian/export/{kelas_mapel_id}',[GuruController::class, 'exportNilai'])->name('guru.penilaian.exportNilai');
    Route::post('/penilaian/import/{kelasMapelId}', [GuruController::class, 'importNilai'])->name('guru.penilaian.importNilai');

    // Wali Kelas
    Route::get('/wali-kelas', [GuruController::class, 'waliKelas'])->name('backend.guru.waliKelas');

    // Layanan
    Route::get('/data-layanan', [GuruController::class, 'layanan'])->name('backend.guru.layanan');
    Route::put('/layanan/update/{id}', [GuruController::class, 'updateLayanan'])->name('guru.layanan.update');
    Route::post('/hasil-layanan', [GuruController::class, 'storeHasilLayanan'])->name('guru.hasilLayanan.store');
    Route::get('/jadwal-layanan', [GuruController::class, 'jadwalLayanan'])->name('backend.guru.jadwalLayanan');
    Route::post('/jadwalLayanan/store', [GuruController::class, 'storeJadwal'])->name('guru.jadwalLayanan.store');
    Route::put('/jadwalLayanan/update/{siswa}', [GuruController::class, 'updateJadwal'])->name('guru.jadwalLayanan.update');
    Route::delete('/jadwalLayanan/delete/{siswa}', [GuruController::class, 'deleteJadwal'])->name('guru.jadwalLayanan.delete');

});


Route::prefix('guru_bk')->middleware(['auth', 'is_guru_bk'])->group(function () {

    Route::get('/index', [BkController::class, 'index'])->name('backend.bk.index');

    // Profil
    Route::get('/profil', [BkController::class, 'profil'])->name('backend.bk.profil');

    // nilai
    Route::get('/nilai', [BkController::class, 'nilai'])->name('backend.bk.nilai');

    // layanan
    Route::get('/jadwalLayanan', [BkController::class, 'jadwal'])->name('backend.bk.jadwalLayanan');
    Route::post('/jadwalLayanan/store', [bkController::class, 'storeJadwal'])->name('bk.jadwalLayanan.store');
    Route::put('/jadwalLayanan/update/{siswa}', [bkController::class, 'updateJadwal'])->name('bk.jadwalLayanan.update');
    Route::delete('/jadwalLayanan/delete/{siswa}', [bkController::class, 'deleteJadwal'])->name('bk.jadwalLayanan.delete');
    Route::get('/layanan', [BkController::class, 'layanan'])->name('backend.bk.layanan');
    Route::post('/hasil-layanan', [BkController::class, 'storeHasilLayanan'])->name('bk.hasilLayanan.store');
    Route::put('/hasil-layanan/{id}', [BkController::class, 'updateHasilLayanan'])->name('bk.hasilLayanan.update');
    Route::put('/layanan/update/{id}', [BKController::class, 'updateLayanan'])->name('bk.layanan.update');
    Route::post('/layanan/store', [BkController::class, 'storeLayanan'])->name('backend.bk.layanan.store'); 
    Route::get('/layanan/semua-data', [BkController::class, 'data_layanan_siswa'])->name('backend.bk.data_layanan_siswa');
    Route::post('/data_layanan_siswa/store', [BkController::class, 'storeDataLayananSiswa'])->name('backend.bk.data_layanan_siswa.store');

    // bulan kehadiran
    Route::get('/bulan-kehadiran', [BkController::class, 'bulanKehadiran'])->name('backend.bk.bulan-kehadiran');
    Route::post('/bulan-kehadiran/store', [BkController::class, 'storeBulanKehadiran'])->name('bk.bulan-kehadiran.store');
    Route::delete('/bulan-kehadiran/delete/{id}', [BkController::class, 'deleteBulanKehadiran'])->name('bk.bulan-kehadiran.delete');

    // kehadiran siswa
    Route::get('/kehadiran-siswa', [BkController::class, 'kehadiranSiswa'])->name('backend.bk.kehadiranSiswa');
    Route::put('/kehadiran/update/{id}', [BkController::class, 'updateKehadiranSiswa'])->name('bk.kehadiranSiswa.update');
    Route::get('/kehadiran/export/{bulanKehadiranId}', [BkController::class, 'exportKehadiranSiswa'])->name('bk.kehadiranSiswa.export');
    Route::post('/kehadiran/import/{bulanKehadiranId}', [BkController::class, 'importKehadiranSiswa'])->name('bk.kehadiranSiswa.import');

});

Route::prefix('kepala_sekolah')->middleware(['auth', 'is_kepsek'])->group(function () {
  
    Route::get('/index', [KepsekController::class, 'index'])->name('backend.kepsek.index');

    // Profil
    Route::get('/profil', [KepsekController::class, 'profil'])->name('backend.kepsek.profil');
    Route::put('/profil/update/{id}', [KepsekController::class, 'updateProfil'])->name('kepsek.profil.update');

    // nilai kelas
    Route::get('/nilai-kelas', [KepsekController::class, 'nilaiKelas'])->name('nilai_kelas');
    Route::post('/nilai-kelas', [KepsekController::class, 'cariNilaiKelas'])->name('cari_nilai_kelas');

    // kehadiran siswa
    Route::get('/kehadiran', [KepsekController::class, 'kehadiran'])->name('backend.kepsek.kehadiran');
    Route::post('/kehadiran/cari', [KepsekController::class, 'cari'])->name('kepsek.kehadiran.cari');
});  

Route::prefix('admin')->middleware(['auth', 'is_admin'])->group(function () {

    // Beranda
    Route::get('/index', [AdminController::class, 'index'])->name('backend.admin.index');
    
    // Daftar Ulang
    Route::post('/daftar-ulang-toggle', [AdminController::class, 'toggleDaftarUlang'])->name('admin.daftar-ulang.toggle');

    // Profil
    Route::get('/profil', [AdminController::class, 'profil'])->name('backend.admin.profil');
    Route::post('/profil/store', [AdminController::class, 'storeProfil'])->name('admin.profil.store');
    Route::put('/profil/{user}', [AdminController::class, 'updateProfil'])->name('admin.profil.update');
    Route::delete('/profil/{user}', [AdminController::class, 'deleteProfil'])->name('admin.profil.delete');
    
    // Guru
    Route::get('/guru', [AdminController::class, 'guru'])->name('backend.admin.guru');
    Route::post('/guru/store', [AdminController::class, 'storeGuru'])->name('admin.guru.store');
    Route::post('/guru/import', [AdminController::class, 'importGuru'])->name('admin.guru.import');
    Route::get('/guru/export', [AdminController::class, 'exportGuru'])->name('admin.guru.export');
    Route::put('/guru/{guru}', [AdminController::class, 'updateGuru'])->name('admin.guru.update');
    Route::delete('/guru/{guru}', [AdminController::class, 'deleteGuru'])->name('admin.guru.delete');

    // Data Semua Siswa
    Route::get('/siswa', [AdminController::class, 'data_siswa'])->name('backend.admin.data_siswa');
    Route::post('/siswa/store', [AdminController::class, 'storeSiswa'])->name('admin.siswa.store');
    Route::post('/siswa/import', [AdminController::class, 'importSiswa'])->name('admin.siswa.import');
    Route::put('/semua-siswa/{siswa}', [AdminController::class, 'updateSemuaSiswa'])->name('admin.semuaSiswa.update');
    Route::delete('/semua-siswa/{siswa}', [AdminController::class, 'deleteSemuaSiswa'])->name('admin.semuaSiswa.delete');

    // Siswa Aktif
    Route::get('/SiswaAktif', [AdminController::class, 'siswa'])->name('backend.admin.siswa');
    Route::get( '/siswa/restore', [AdminController::class, 'restoreViewSiswa'])->name('admin.siswa.restoreViewSiswa');
    Route::get('/siswa/export', [AdminController::class, 'exportSiswa'])->name('admin.siswa.exportSiswa');
    Route::get('/siswa/siswa-kelas/{kelas_id}/export', [AdminController::class, 'exportSiswaKelas'])->name('admin.siswa.export');
    Route::put('/siswa/{siswa}', [AdminController::class, 'updateSiswa'])->name('admin.siswa.update');
    Route::delete('/siswa/{siswa}', [AdminController::class, 'deleteSiswa'])->name('admin.siswa.delete');
    Route::post('/kelas/siswa-restore/{id}', [AdminController::class, 'restoreSiswa'])->name('admin.siswa.restoreSiswa');
    Route::delete('/kelas/siswa-permanent/{id}', [AdminController::class, 'deleteSiswaPermanent'])->name('admin.siswa.deleteSiswaPermanent');

    // Tahun
    Route::get('/tahun', [AdminController::class, 'tahun'])->name('backend.admin.tahun');
    Route::post('/tahun/store', [AdminController::class, 'storeTahun'])->name('admin.tahun.store');
    Route::put('/tahun/{tahun}', [AdminController::class, 'updateTahun'])->name('admin.tahun.update');
    Route::delete('/tahun/{tahun}', [AdminController::class, 'deleteTahun'])->name('admin.tahun.delete');

    // Semester
    Route::get('/semester', [AdminController::class, 'semester'])->name('backend.admin.semester');
    Route::post('/semester/store', [AdminController::class, 'storeSemester'])->name('admin.semester.store');
    Route::put('/semester/{semester}', [AdminController::class, 'updateSemester'])->name('admin.semester.update');
    Route::delete('/semester/{semester}', [AdminController::class, 'deleteSemester'])->name('admin.semester.delete');
    
    // Mapel
    Route::get('/mapel', [AdminController::class, 'mapel'])->name('backend.admin.mapel');
    Route::post('/mapel/store', [AdminController::class, 'storeMapel'])->name('admin.mapel.store');
    Route::put('/mapel/{mapel}', [AdminController::class, 'updateMapel'])->name('admin.mapel.update');
    Route::delete('/mapel/{mapel}', [AdminController::class, 'deleteMapel'])->name('admin.mapel.delete');

    // Kelas
    Route::get('/kelas', [AdminController::class, 'kelas'])->name('backend.admin.kelas');
    Route::post('/kelas/store', [AdminController::class, 'storeKelas'])->name('admin.kelas.store');
    Route::post('/kelas/import', [AdminController::class, 'importKelas'])->name('admin.kelas.import');
    Route::put('/kelas/{kelas}', [AdminController::class, 'updateKelas'])->name('admin.kelas.update');
    Route::delete('/kelas/{kelas}', [AdminController::class, 'deleteKelas'])->name('admin.kelas.delete');
    Route::post('/kelas/duplikat-semester', [AdminController::class, 'duplikatSemester'])->name('admin.kelas.duplikat');

    // Detail Siswa
    Route::get('/kelas/detail-kelas', [AdminController::class, 'detailKelas'])->name('admin.kelas.detailKelas');
    Route::match(['get', 'post'], '/kelas/detail-kelas/filter', [AdminController::class, 'detailKelas'])->name('admin.detailKelas.filter');
    Route::post('/kelas/siswa-kelas-mapel/store', [AdminController::class, 'storeDetailKelas'])->name('admin.detailKelas.store');
    Route::post('/kelas/siswa-kelas-mapel/import', [AdminController::class, 'importDetailKelas'])->name('admin.detailKelas.import');
    Route::get('/kelas/detail-kelas/{kelas_id}/export', [AdminController::class, 'exportGuruMapel'])->name('admin.detailKelas.export');
    Route::post('/kelas/duplikat-detail-kelas', [AdminController::class, 'duplikatDetailKelas'])->name('admin.detailKelas.duplikat');   
    Route::post('/kelas/detail-kelas-mapel/delete/{id}', [AdminController::class, 'deleteKelasMapel'])->name('admin.kelasMapel.delete');
    Route::post('/kelas/detail-siswa-kelas/delete/{id}', [AdminController::class, 'deleteSiswaKelas'])->name('admin.siswaKelas.delete');
    Route::delete('/kelas/detail-kelas/{kelas}', [AdminController::class, 'deleteDetailKelas'])->name('admin.detailKelas.delete');
    Route::get( '/kelas/restore', [AdminController::class, 'restoreViewKelas'])->name('admin.kelas.restoreViewKelas');
    Route::post('/kelas/Kelas-restore/{id}', [AdminController::class, 'restoreKelas'])->name('admin.kelas.restoreKelas');
    Route::delete('/kelas/Kelas-permanent/{id}', [AdminController::class, 'deleteKelasPermanent'])->name('admin.kelas.deleteKelasPermanent');
    Route::post('/kelas/detail-kelas/delete-filtered', [AdminController::class, 'deleteFiltered'])->name('admin.detailKelas.deleteFiltered');

});
