
<?php $__env->startSection('content'); ?>

<!-- Include CSS Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />


<style>

.select2-container .select2-selection--single {
    height: 50px; /* tinggi */
    padding: 10px;
    font-size: 16px;
    display: flex;
    align-items: center;
    border-radius: 5px;
    transition: all 0.3s ease; /* haluskan transisi */
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: normal;
    padding-left: 20px; /* tambah padding kiri supaya gak ketiban X */
}

.select2-container--default .select2-selection--single:focus,
.select2-container--default .select2-selection--single:hover {
    border-color: #007bff;
}

.select2-dropdown {
    border-radius: 3px;
    border: 1px solid #007bff;
}

.select2-container--default .select2-selection--single .select2-selection__clear {
    position: absolute;
    left: 10px; /* X pindah ke kiri */
    right: auto;
    top: 50%;
    transform: translateY(-50%);
    font-size: 20px;
    color: #dc3545; /* warna merah Bootstrap danger */
    cursor: pointer;
}

select:invalid {
  color: #6c757d; /* Abu-abu untuk placeholder */
}
select:valid {
  color: #000000; /* Hitam setelah pilih */
}

</style>

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA KELAS</h4>

      <div class="row mb-3">
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createKelasModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-dark w-100" data-toggle="modal" data-target="#uploadModal">
      <i class="bi bi-upload btn-icon-prepend mr-1"></i> Import
    </button>
  </div>
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form action="<?php echo e(route('admin.kelas.detailKelas')); ?>" method="GET" class="d-inline">
      <button type="submit" class="btn btn-success w-100">
        <i class="bi bi-eye btn-icon-prepend mr-1"></i>
        Detail Kelas
      </button>
    </form>
  </div>
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form>
      <input id="search-input" class="form-control w-100" type="search" placeholder="Search Kelas & Tahun" aria-label="Search">
    </form>
  </div>
</div>

      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
              <th>No</th>
              <th>Nama Kelas</th>
              <th>Wali Kelas</th>
              <th>Semester</th>
              <th>Tahun Ajaran</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $kelas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="text-center">
              <td><?php echo e($loop->iteration); ?></td>
              <td class="kelas"><?php echo e($k->nama); ?></td>
              <td><?php echo e($k->waliKelas->name); ?></td>
              <td><?php echo e($k->semester->semester); ?></td>
              <td class="tahun"><?php echo e($k->semester->tahunAjaran->tahun_awal); ?>/<?php echo e($k->semester->tahunAjaran->tahun_akhir); ?></td>
              <td>
                <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editKelasModal-<?php echo e($k->id); ?>">
                    <i class="mdi mdi-pencil"></i>
                    </a>
                    <!-- <form action="<?php echo e(route('admin.kelas.delete', $k->id)); ?>" method="POST" class="d-inline-block form-delete">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                    </form> -->
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- modal upload -->
<div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="<?php echo e(route('admin.kelas.import')); ?>" method="POST" enctype="multipart/form-data">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="uploadModalLabel">Upload File Excel</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label for="file">File Excel Kelas (xlsx)</label>
            <input type="file" name="file" class="form-control" required>
            <div class="mt-2">
              <a href="<?php echo e(asset('template_import_kelas.xlsx')); ?>" class="btn btn-primary text-white btn-sm w-100" download>
                Download Template Kelas
              </a>
            </div>
          </div>
        </div>
        <div class="modal-footer w-100">
          <div class="row w-100 d-flex justify-content-between">
            <div class="col-12 col-lg-auto mb-2">
              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
            </div>
            <div class="col-12 col-lg-auto mb-2">
              <button type="submit" class="btn btn-dark w-100 w-lg-auto">Import</button>
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal Create -->
<div class="modal fade" id="createKelasModal" tabindex="-1" role="dialog" aria-labelledby="createKelasModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form action="<?php echo e(route('admin.kelas.store')); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Tambah Kelas</h5>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label>Nama Kelas</label>
            <input type="text" class="form-control" name="nama" placeholder="Nama Kelas" required>
          </div>

          <div class="form-group">
            <label>Wali Kelas</label>
            <select name="wali_kelas_id" class="form-control select2" required>
              <option value="">-- Pilih Wali Kelas --</option>
              <?php $__currentLoopData = $guruAktif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($g->id); ?>"><?php echo e($g->name); ?> (<?php echo e($g->guru->nip); ?>)</option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div class="form-group">
            <label for="semesterSelect">Semester</label>
            <select name="semester_id" class="form-control semester-select" id="semesterSelect" required>
              <option value="" selected hidden>-- Pilih Semester --</option>
              <?php $__currentLoopData = $semester; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $smt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($smt->id); ?>" data-tahun-ajaran-id="<?php echo e($smt->tahunAjaran->id); ?>">
                  <?php echo e($smt->semester); ?> - <?php echo e($smt->tahunAjaran->tahun_awal); ?>/<?php echo e($smt->tahunAjaran->tahun_akhir); ?>

                </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

            <div class="form-group">
                <label for="tahunAjaranSelect">Tahun Ajaran</label>
                <select name="tahun_ajaran_id" class="form-control tahun-ajaran-select" id="tahunAjaranSelect" required readonly>
                  <option value="" selected hidden>JANGAN DI UBAH</option>
                  <?php $__currentLoopData = $tahun; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($t->id); ?>">
                    <?php echo e($t->tahun_awal); ?> / <?php echo e($t->tahun_akhir); ?>

                  </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <small class="form-text text-danger">* Jangan diubah Tahun Ajarannya</small>
            </div>

        </div>
        <div class="modal-footer w-100">
          <div class="row w-100 d-flex justify-content-between">
            <div class="col-12 col-lg-auto mb-2">
              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
            </div>
            <div class="col-12 col-lg-auto mb-2">
              <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- Modal Update -->
<?php $__currentLoopData = $kelas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editKelasModal-<?php echo e($k->id); ?>" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <form action="<?php echo e(route('admin.kelas.update', $k->id)); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PUT'); ?>
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Edit Kelas</h5>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">

          <div class="form-group">
            <label>Nama Kelas</label>
            <input type="text" class="form-control" name="nama" value="<?php echo e($k->nama); ?>" required>
          </div>

          <div class="form-group">
            <label>Wali Kelas</label>
            <select name="wali_kelas_id" class="form-control select2" required>
              <option value="">-- Pilih Wali Kelas --</option>
              <?php $__currentLoopData = $guruAktif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($g->id); ?>" <?php echo e($k->wali_kelas_id == $g->id ? 'selected' : ''); ?>><?php echo e($g->name); ?> (<?php echo e($g->guru->nip); ?>)</option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div class="form-group">
  <label for="semesterSelect">Semester</label>
  <select name="semester_id" class="form-control semester-select" id="semesterSelect" required readonly>
    <option value="">-- Pilih Semester --</option>
    <?php $__currentLoopData = $semester; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <option value="<?php echo e($s->id); ?>" data-tahun-ajaran-id="<?php echo e($s->tahunAjaran->id); ?>" <?php echo e($k->semester_id == $s->id ? 'selected' : ''); ?>>
      Semester <?php echo e($s->semester); ?> (<?php echo e($s->tahunAjaran->tahun_awal); ?>/<?php echo e($s->tahunAjaran->tahun_akhir); ?>)
    </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </select>
  <small class="form-text text-danger">* Jangan diubah Tahun Ajarannya</small>
</div>

<div class="form-group">
  <label for="tahunAjaranSelect">Tahun Ajaran</label>
  <select name="tahun_ajaran_id" class="form-control tahun-ajaran-select" id="tahunAjaranSelect" required readonly>
    <?php $__currentLoopData = $tahun; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <option value="<?php echo e($t->id); ?>" <?php echo e($k->tahun_ajaran_id == $t->id ? 'selected' : ''); ?>>
      <?php echo e($t->tahun_awal); ?> / <?php echo e($t->tahun_akhir); ?>

    </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </select>
  <small class="form-text text-danger">* Jangan diubah Tahun Ajarannya</small>
</div>
        </div>
         <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                    </div>
                  </div>
          </div>
      </div>
    </form>
  </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Include JS Select2 -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    document.getElementById('search-input').addEventListener('keyup', function () {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');

        rows.forEach(function (row) {
            var kelas = row.querySelector('.kelas')?.textContent.toLowerCase() || '';
            var tahun = row.querySelector('.tahun')?.textContent.toLowerCase() || '';
            var combined = kelas + ' ' + tahun;

            if (combined.includes(searchValue)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>


<script>
  $(document).ready(function () {
    // Saat semester berubah
    $('.semester-select').on('change', function () {
      // Ambil tahun ajaran id dari option yang dipilih
      const tahunAjaranId = $(this).find(':selected').data('tahun-ajaran-id');

      // Cari select tahun ajaran dalam modal yang sama
      const modal = $(this).closest('.modal');
      modal.find('.tahun-ajaran-select').val(tahunAjaranId);
    });
  });

</script>


<script>
  $(document).ready(function () {
    $('.select2').each(function () {
      const modalParent = $(this).closest('.modal');
      $(this).select2({
        placeholder: "-- Pilih Wali Kelas --",
        allowClear: true,
        width: '100%',
        dropdownParent: modalParent.length ? modalParent : $(document.body)
      });
    });
  });
</script>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
<!-- SweetAlert -->
<script>
  <?php if(session('success')): ?>
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '<?php echo e(session('success')); ?>',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  <?php endif; ?>

<?php if($errors->any()): ?>
    Swal.fire({
        icon: 'error',
        title: 'Gagal!',
        text: <?php echo json_encode($errors->first(), 15, 512) ?>,
        confirmButtonColor: '#d33',
        customClass: {
            popup: 'swal-popup-tall',
        },
    });
<?php endif; ?>

</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();
        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: "Data Kelas akan dihapus permanen!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: { popup: 'swal-popup-tall' }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout.template_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\silakan\resources\views/backend/admin/kelas.blade.php ENDPATH**/ ?>