<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KelasMapel extends Model
{
    use HasFactory;

    protected $table = 'kelas_mapel';
    protected $fillable = ['kelas_id', 'mapel_id', 'guru_id'];

    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }

    public function mapel()
    {
        return $this->belongsTo(Mapel::class);
    }

    public function guru()
    {
        return $this->belongsTo(Guru::class, 'guru_id', 'guru_id')->with('user');
    }

     public function nilai()
    {
        return $this->hasMany(Nilai::class, 'kelas_mapel_id', 'id');
    }

}
