<?php

    namespace App\Models;

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Factories\HasFactory;

    class Nilai extends Model
    {
        use HasFactory;

        protected $table = 'nilai';

        protected $fillable = [
            'siswa_id',
            'kelas_mapel_id',
            's_nilai',
        ];

        protected $casts = [
            's_nilai' => 'array',
        ];

        public function siswa()
        {
            return $this->belongsTo(Siswa::class);
        }

        public function kelasMapel()
        {
            return $this->belongsTo(KelasMapel::class, 'kelas_mapel_id');
        }
    }
