<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class IsGuru
{
    public function handle(Request $request, Closure $next)
    {
        // Kalau user login dan role-nya "guru", lanjut
        if (Auth::check() && Auth::user()->role === 'guru') {
            return $next($request);
        }

        abort(403, 'Anda tidak memiliki akses sebagai guru.');
    }
}
