<?php

namespace App\Imports;

use App\Models\Guru;
use App\Models\Mapel;
use App\Models\KelasMapel;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class GuruMapelImport implements ToModel, WithHeadingRow
{
    protected $kelasId;

    public function __construct($kelasId)
    {
        $this->kelasId = $kelasId;
    }

    public function model(array $row)
    {
        // Validasi input
        if (!isset($row['nip']) || !isset($row['mapel'])) {
            Log::warning("Kolom 'nip' atau 'mapel' tidak ditemukan di baris: " . json_encode($row));
            return null;
        }

        $guru = Guru::where('nip', $row['nip'])->first();

        if (!$guru || !$guru->user) {
            throw new \Exception("Guru dengan NIP {$row['nip']} atau user-nya tidak ditemukan.");
        }

        $userId = $guru->guru_id;

        $namaMapel = $row['mapel'];
        $mapelId = $this->getMapelIdByName($namaMapel);

        $exists = KelasMapel::where('kelas_id', $this->kelasId)
            ->where('guru_id', $userId)
            ->where('mapel_id', $mapelId)
            ->exists();

        if ($exists) {
            Log::info("Duplikat GuruMapel: kelas_id={$this->kelasId}, guru_id={$guru->id}, mapel_id={$mapelId}");
            return null;
        }

        // Simpan data baru
        return new KelasMapel([
            'kelas_id' => $this->kelasId,
            'mapel_id' => $mapelId,
            'guru_id'  => $userId, // harus user_id!
        ]);
    }

    protected function getMapelIdByName($nama)
    {
        $mapel = Mapel::where('nama', $nama)->first();

        if (!$mapel) {
            throw new \Exception("Mapel dengan nama '{$nama}' tidak ditemukan.");
        }

        return $mapel->id;
    }
}
