@extends('backend.layout.template_admin')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title mb-3">DATA MAPEL</h4>
            <div class="row mb-3">
  <!-- Tombol Tambah -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <button type="button" class="btn btn-primary w-100" data-toggle="modal" data-target="#createMapelModal">
      <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i> Tambah
    </button>
  </div>

  <!-- Search -->
  <div class="col-12 col-sm-6 col-md-3 mb-2">
    <form>
      <input id="search-input" class="form-control w-100" type="search" placeholder="Search Mapel" aria-label="Search">
    </form>
  </div>
</div>
      <div class="table-responsive">
        <table class="table table-striped">
          <thead>
            <tr class="text-center">
                <th>No</th>
                <th>Mata Pelajaran</th>
                <th>Tipe Mapel</th>
                <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($mapel as $m)
            <tr class="text-center">
                <td>{{ $loop->iteration }}</td> 
                <td class="mapel">{{ $m->nama }}</td>
                <td>
                    {{ $m->tipe ? 'Penilaian' : 'Non Penilaian' }}
                </td>
                <td>
                    <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editMapelModal-{{ $m->id }}">
                    <i class="mdi mdi-pencil"></i>
                    </a>
                    <form action="{{ route('admin.mapel.delete', $m->id) }}" method="POST" class="d-inline-block form-delete" data-nama="{{ $m->nama }}">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
                        <i class="mdi mdi-delete-forever"></i>
                    </button>
                    </form>
                </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- modal create -->
<div class="modal fade" id="createMapelModal" tabindex="-1" role="dialog" aria-labelledby="createMapelModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.mapel.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createMapelModalLabel">Tambah Mata Pelajaran</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <div class="form-group">
                        <label for="mapel" class="form-label">Mata Pelajaran</label>
                        <input type="text" class="form-control" name="nama" placeholder="Mata Pelajaran">
                    </div>

                    <div class="form-group">
                        <label for="tipe" class="form-label">Tipe Mapel</label>
                        <select class="form-control" name="tipe" required>
                            <option value="" selected hidden>Pilih Tipe Mapel</option>
                            <option value="1">Mapel Penilaian</option>
                            <option value="0">Mapel Non Penilaian</option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer w-100">
                <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                    <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                    <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                    </div>
                </div>
                </div>
            </div>
        </form>
    </div>
</div>


@foreach ($mapel as $m)
<!-- modal update -->
<div class="modal fade" id="editMapelModal-{{ $m->id }}" tabindex="-1" role="dialog" aria-labelledby="editMapelModalLabel-{{ $m->id }}" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="{{ route('admin.mapel.update', $m->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editMapelModalLabel-{{ $m->id }}">Edit Mata Pelajaran</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <input type="hidden" name="id" value="{{ $m->id }}">

                    <div class="form-group">
                        <label for="mapel" class="form-label">Mata Pelajaran</label>
                        <input type="text" class="form-control" name="nama" value="{{ $m->nama }}">
                    </div>

                    <div class="form-group">
                        <label for="tipe" class="form-label">Tipe Mapel</label>
                        <select class="form-control text-dark" name="tipe" required>
                            <option value="" hidden>Pilih Tipe Mapel</option>
                            <option value="1" {{ $m->tipe == 1 ? 'selected' : '' }}>Mapel Penilaian</option>
                            <option value="0" {{ $m->tipe == 0 ? 'selected' : '' }}>Mapel Non Penilaian</option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                    </div>
                  </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endforeach

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    document.getElementById('search-input').addEventListener('keyup', function() {
        var searchValue = this.value.toLowerCase();
        var rows = document.querySelectorAll('.table tbody tr');
        
        rows.forEach(function(row) {
            var item = row.querySelector('.mapel').textContent.toLowerCase();
            if (item.indexOf(searchValue) > -1) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const namaMapel = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus?',
          text: `Data Mapel ${namaMapel} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>



@endsection