    @extends('backend.layout.template_bk')
    @section('content')

    {{-- Dropdown Kelas (ambil dari KelasMapel) --}}
    <div class="row mb-4">
    <div class="col-12 col-md-6 col-lg-4">
        <div class="dropdown w-100">
        <button class="btn btn-danger dropdown-toggle w-100"
                type="button"
                id="dropdownMenuSizeButton"
                data-toggle="dropdown"
                aria-haspopup="true"
                aria-expanded="false">
            Pilih Kelas
        </button>
        <div class="dropdown-menu w-100" aria-labelledby="dropdownMenuSizeButton">
            @foreach($dropdownKelas as $dk)
            @php
                $param = $dk['nama'] . '-' . $dk['tahun_ajaran_id'];
            @endphp
            <a class="dropdown-item {{ ($selectedKey === $param) ? 'active' : '' }}"
                href="{{ route('backend.bk.kehadiranSiswa', ['kelas' => $param]) }}">
                {{ $dk['nama'] }} -
                {{ optional(\App\Models\TahunAjaran::find($dk['tahun_ajaran_id']))->tahun_awal }}
                /
                {{ optional(\App\Models\TahunAjaran::find($dk['tahun_ajaran_id']))->tahun_akhir }}
            </a>
            <div class="dropdown-divider"></div>
            @endforeach
        </div>
        </div>
    </div>
    </div>

    {{-- Jika ada kelas terpilih --}}
    @if($kelases->isNotEmpty())
    {{-- Loop setiap Kelas (semester 1 & 2) --}}
    @foreach($kelases as $kelasObj)
        @php
        $dataK       = $kehadiranAll[$kelasObj->id] ?? ['bulanList' => collect()];
        $bulanList   = $dataK['bulanList'];
        @endphp

        {{-- Jika sama sekali belum ada entri BulanKehadiran --}}
        @if($bulanList->isEmpty())
        <div class="alert alert-warning mb-4">
            Kelas <strong>{{ $kelasObj->nama }} semester {{ $kelasObj->semester->semester }}
            {{ $kelasObj->tahunAjaran->tahun_awal }}/{{ $kelasObj->tahunAjaran->tahun_akhir }}</strong><br>
            Belum ada bulan kehadiran. Silahkan tambahkan terlebih dahulu kelas ini ke Bulan Kehadiran.
        </div>
        @else
        {{-- Loop setiap BulanKehadiran untuk kelas ini --}}
        @foreach($bulanList as $bulanEntryId => $dataB)
            @php
            $bulanModel  = $dataB['model'];
            $kehadirans  = $dataB['kehadiran'];
            @endphp

            <div class="col-lg-12 grid-margin stretch-card mb-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mt-1">
                    DATA KEHADIRAN SISWA 
                    </h4>
    <!-- Baris 1: Bulan (kiri) dan Kelas (kanan) -->
    <div class="row mb-3">
    <div class="col-12 col-md-6 mb-2">
        <code style="font-weight: bold;">
        <span class="text-dark">Bulan :</span> {{ \Carbon\Carbon::parse($bulanModel->bulan)->translatedFormat('F Y') }}
        </code>
    </div>
    <div class="col-12 col-md-6 text-md-right mb-2">
        <code style="font-weight: bold;">
        <span class="text-dark">Kelas :</span> {{ $kelasObj->nama }} - Semester {{ $kelasObj->semester->semester }} - 
        {{ $kelasObj->tahunAjaran->tahun_awal }}/{{ $kelasObj->tahunAjaran->tahun_akhir }}
        </code>
    </div>
    </div>

    <!-- Baris 2: Search (kiri) dan Tombol Tambah Kehadiran (kanan) -->
    <div class="row mb-3 d-flex justify-content-between">
        <div class="col-12 col-sm-6 col-md-3 mb-2">
        <button class="btn btn-dark w-100" data-toggle="modal" data-target="#uploadModal-{{ $bulanModel->id }}">
            <i class="bi bi-arrow-down-up btn-icon-prepend mr-1"></i>Import & Export
        </button>
    </div>
        

    <div class="col-12 col-sm-6 col-md-3 mb-2">
        <form>
<input
  class="form-control w-100 search-kehadiran"
  type="search"
  placeholder="Cari Nama/NISN"
  aria-label="Search"
/>

        </form>
    </div>
    </div>



                <div class="table-responsive">
                    <table class="table table-striped table-kehadiran">

                    <thead class="text-center">
                        <tr>
                        <th>NISN</th>
                        <th>Nama</th>
                        <th>Sakit</th>
                        <th>Izin</th>
                        <th>Alpha</th>
                        <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($kehadirans->isEmpty())
                        <tr>
                            <td colspan="6">Belum ada data kehadiran untuk bulan {{ $bulanModel->bulan }}.</td>
                        </tr>
                        @else
                        @foreach($kehadirans as $row)
                            <tr class="text-center">
                            {{-- NISN --}}
                            <td class="nisn">{{ optional($row->siswa->siswa)->nisn ?? '-' }}</td>
                            {{-- Nama --}}
                            <td class="nama">{{ $row->siswa->name }}</td>
                            {{-- Sakit, Izin, Alpha --}}
                            <td>{{ $row->sakit ?? 0 }}</td>
                            <td>{{ $row->izin ?? 0 }}</td>
                            <td>{{ $row->alpha ?? 0 }}</td>
                            {{-- Tombol Detail --}}
                            <td>
                                <button class="btn btn-sm btn-warning text-white"
            title="Edit"
            data-toggle="modal"
            data-target="#updateModal-{{ $row->id }}">
    <i class="mdi mdi-pencil"></i>
    </button>

                            </td>
                            </tr>
                        @endforeach
                        @endif
                    </tbody>
                    </table>
                </div>
                </div>
            </div>
            </div>

            <!-- modal upload -->
    <div class="modal fade" id="uploadModal-{{ $bulanModel->id }}" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
        <div class="modal-header d-flex justify-content-between align-items-center">
            <h5 class="modal-title" id="uploadModalLabel">Upload File Excel</h5>
            <div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            <form action="{{ route('bk.kehadiranSiswa.export', $bulanModel->id) }}" method="GET" class="mb-3">
                <button type="submit" class="btn btn-primary">
                    Export Excel
                </button>
            </form>
            </div>
        </div>
        <form action="{{ route('bk.kehadiranSiswa.import', $bulanModel->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="modal-body">
            <div class="form-group">
                <label for="file">File Excel Kehadiran (xlsx)</label>
                <input type="file" name="file" class="form-control" required>
            </div>
            </div>    
            <div class="modal-footer w-100">
            <div class="row w-100 d-flex justify-content-between">
                <div class="col-12 col-lg-auto mb-2">
                <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                </div>
                <div class="col-12 col-lg-auto mb-2">
                <button type="submit" class="btn btn-dark w-100 w-lg-auto">Import</button>
                </div>
            </div>
            </div>
        </form>
        </div>
    </div>
    </div>

            {{-- Modal Update per siswa --}}
    @foreach($kehadirans as $row)
    <div class="modal fade"
            id="updateModal-{{ $row->id }}"
        tabindex="-1" role="dialog">
        <div class="modal-dialog modal-md modal-dialog-centered" role="document">
        <div class="modal-content">
            <form action="{{ route('bk.kehadiranSiswa.update', $row->id) }}" method="POST">
            @csrf
            @method('PUT')
            <input type="hidden" name="redirect_back" value="1">

            <div class="modal-header">
                <h5 class="modal-title">
                Edit Kehadiran : <span class="text-danger">{{ $row->siswa->name }} ({{ $row->siswa->siswa->nisn }})</span>
                </h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
            </div>

            <div class="modal-body">
                <p class="d-flex justify-content-end">Bulan : <strong class="text-danger" style="font-weight: bold;"> {{ \Carbon\Carbon::parse($bulanModel->bulan)->translatedFormat('F Y') }}</strong></p>
                <hr>
                <div class="form-group">
                <label for="sakit">Sakit</label>
                <input type="number" class="form-control" name="sakit" value="{{ $row->sakit ?? 0 }}" min="0">
                </div>
                <div class="form-group">
                <label for="izin">Izin</label>
                <input type="number" class="form-control" name="izin" value="{{ $row->izin ?? 0 }}" min="0">
                </div>
                <div class="form-group">
                <label for="alpha">Alpha</label>
                <input type="number" class="form-control" name="alpha" value="{{ $row->alpha ?? 0 }}" min="0">
                </div>
            </div>

            <div class="modal-footer w-100">
                    <div class="row w-100 d-flex justify-content-between">
                        <div class="col-12 col-lg-auto mb-2">
                        <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                        </div>
                        <div class="col-12 col-lg-auto mb-2">
                        <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                        </div>
                    </div>
                    </div>
            </form>
        </div>
        </div>
    </div>
    @endforeach


        @endforeach
        @endif

    @endforeach
    @else
    <div class="alert alert-warning">
        Silahkan pilih kelas terlebih dahulu untuk melihat kehadiran siswa.
    </div>
    @endif

    <script>
        document.getElementById('search-input').addEventListener('keyup', function() {
            var searchValue = this.value.toLowerCase();
            var rows = document.querySelectorAll('.table tbody tr');
            
            rows.forEach(function(row) {
                var nip = row.querySelector('.nisn')?.textContent.toLowerCase() || '';
                var nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
                var combined = nip + ' ' + nama;
                if (combined.includes(searchValue)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    </script>


    <style>
    .swal-popup-tall {
    height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
    display: flex;
    flex-direction: column;
    justify-content: center;
    }
    </style>

    <script>
        @if (session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: '{{ session('success') }}',
                confirmButtonColor: '#3085d6',
                customClass: {
                    popup: 'swal-popup-tall',
                }
            });
        @endif

        @if ($errors->any())
            Swal.fire({
                icon: 'error',
                title: 'Gagal!',
                text: '{{ $errors->first() }}',
                confirmButtonColor: '#d33',
                customClass: {
                    popup: 'swal-popup-tall',
                }
            });
        @endif
    </script>

    @if ($errors->has('import_error'))
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Gagal Import!',
            text: '{{ $errors->first("import_error") }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    </script>
@endif

<script>
  document.addEventListener('DOMContentLoaded', function () {
    // Ambil semua input search yang pakai class `search-kehadiran`
    const searchInputs = document.querySelectorAll('.search-kehadiran');

    searchInputs.forEach(function (input) {
      input.addEventListener('keyup', function () {
        const searchValue = input.value.toLowerCase();

        // Cari elemen table terdekat (yang ada di dalam parent yang sama)
        const table = input.closest('.card-body').querySelector('.table-kehadiran');
        const rows = table.querySelectorAll('tbody tr');

        rows.forEach(function (row) {
          const nisn = row.querySelector('.nisn')?.textContent.toLowerCase() || '';
          const nama = row.querySelector('.nama')?.textContent.toLowerCase() || '';
          const combined = nisn + ' ' + nama;

          row.style.display = combined.includes(searchValue) ? '' : 'none';
        });
      });
    });
  });
</script>


    @endsection
