@extends('backend.layout.template_guru')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <div class="row mb-3 d-flex justify-content-between">
                    <div class="col-12 col-sm-6 col-md-3">
                      <h4 class="card-title">Jadwal Layanan</h4>
                    </div>
                    <div class="col-12 col-sm-6 col-md-3 mb-2">
                      <button type="button" class="btn btn-primary btn-sm w-100" data-toggle="modal" data-target="#TambahJadwal">
                        <i class="bi bi-plus-circle btn-icon-prepend mr-1"></i>
                          Tambah
                      </button>
                    </div>
                  </div>
                  <div class="table-responsive">
                    <table class="table table-striped">
                      <thead>
                        <tr class="text-center">
                          <th>
                            Hari Layanan
                          </th>
                          <th>
                            Jam Layanan
                          </th>
                          <th>
                            Aksi
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach ($jadwals as $jadwal)
<tr class="text-center">
  <td>{{ $jadwal->hari }}</td>
  <td>{{ $jadwal->jam }}</td>
  <td>
    <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#EditJadwal-{{ $jadwal->id }}">
      <i class="mdi mdi-pencil"></i>
    </a>
    <form action="{{ route('guru.jadwalLayanan.delete', $jadwal->id) }}" method="POST" class="d-inline-block form-delete"
    data-nama="jadwal hari {{ $jadwal->hari }} jam {{ $jadwal->jam }}">
      @csrf
      @method('DELETE')
      <button type="submit" class="btn btn-danger btn-sm text-white" title="Hapus">
        <i class="mdi mdi-delete-forever"></i>
      </button>
    </form>
  </td>
</tr>
@endforeach

                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>

            <div class="modal fade" id="TambahJadwal" tabindex="-1" aria-labelledby="detailModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="detailModalLabel">Tambah Jadwal</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!-- Form Input untuk Detail Nilai -->
        <form action="{{ route('guru.jadwalLayanan.store') }}" method="POST" class="forms-sample">
  @csrf
  <div class="form-group">
    <label for="hari">Hari Layanan</label>
    <select name="hari" class="form-control text-dark" required>
      <option value="" selected hidden>Pilih Hari</option>
      <option value="Senin">Senin</option>
      <option value="Selasa">Selasa</option>
      <option value="Rabu">Rabu</option>
      <option value="Kamis">Kamis</option>
      <option value="Jumat">Jumat</option>
      <option value="Sabtu">Sabtu</option>
    </select>
  </div>
  <div class="form-group">
    <label>Jam Layanan</label>
    <input type="time" name="jam" class="form-control" placeholder="Contoh: 09.00 - 12.00" required>
  </div>
  <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-primary w-100 w-lg-auto">Simpan</button>
                    </div>
                  </div>
                </div>
</form>

      </div>
    </div>
  </div>
</div>

@foreach($jadwals as $jadwal)
<div class="modal fade" id="EditJadwal-{{ $jadwal->id }}" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Jadwal</h5>
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="{{ route('guru.jadwalLayanan.update', $jadwal->id) }}" method="POST">
          @csrf
          @method('PUT')
          <div class="form-group">
            <label>Hari Layanan</label>
            <select name="hari" class="form-control text-dark" required>
              <option value="Senin"  {{ $jadwal->hari == 'Senin' ? 'selected' : '' }}>Senin</option>
              <option value="Selasa" {{ $jadwal->hari == 'Selasa' ? 'selected' : '' }}>Selasa</option>
              <option value="Rabu"   {{ $jadwal->hari == 'Rabu' ? 'selected' : '' }}>Rabu</option>
              <option value="Kamis"  {{ $jadwal->hari == 'Kamis' ? 'selected' : '' }}>Kamis</option>
              <option value="Jumat"  {{ $jadwal->hari == 'Jumat' ? 'selected' : '' }}>Jumat</option>
              <option value="Sabtu"  {{ $jadwal->hari == 'Sabtu' ? 'selected' : '' }}>Sabtu</option>
            </select>
          </div>
          <div class="form-group">
            <label>Jam Layanan</label>
            <input type="time" name="jam" class="form-control" value="{{ $jadwal->jam }}" required>
          </div>
          <div class="modal-footer w-100">
                  <div class="row w-100 d-flex justify-content-between">
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                    <div class="col-12 col-lg-auto mb-2">
                      <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                    </div>
                  </div>
                </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endforeach

<style>
.swal-popup-tall {
  height: 400px !important; /* atur sesuai kebutuhan, bisa 800px juga */
  display: flex;
  flex-direction: column;
  justify-content: center;
}
</style>

<script>
    @if (session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil!',
            text: '{{ session('success') }}',
            confirmButtonColor: '#3085d6',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif

    @if ($errors->any())
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            text: '{{ $errors->first() }}',
            confirmButtonColor: '#d33',
            customClass: {
                popup: 'swal-popup-tall',
            }
        });
    @endif
</script>

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const deleteForms = document.querySelectorAll('.form-delete');
    deleteForms.forEach(form => {
      form.addEventListener('submit', function (e) {
        e.preventDefault();

        const nama = form.dataset.nama;

        Swal.fire({
          title: 'Yakin ingin menghapus ?',
          text: `Data ${nama} ini akan dihapus!`,
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Hapus!',
          cancelButtonText: 'Batal',
          customClass: {
            popup: 'swal-popup-tall',
          }
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
          }
        });
      });
    });
  });
</script>

@endsection