@extends('backend.layout.template_kepsek')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">DATA KEPALA SEKOLAH</h4>
                  <!-- <p class="card-description">
                    Add class <code>.table-striped</code>
                  </p> -->
                  <div class="table-responsive">
  <table class="table table-striped">
    <thead>
      <tr class="text-center">
        <th>No</th>
        <th>NIP</th>
        <th>Nama</th>
        <th>Jekel</th>
        <th>No Hp</th>
        <th>Email</th>
        <th>Aksi</th>
      </tr>
    </thead>
    <tbody>
      @foreach ($guru as $g)
        <tr class="text-center">
          <td>{{ $loop->iteration }}</td>
          <td>{{ $g->nip }}</td>
          <td>{{ $g->user->name }}</td>
          <td>{{ $g->jenis_kelamin }}</td>
          <td>{{ $g->no_hp }}</td>
          <td>{{ $g->user->email }}</td>
          <td>
             <a href="#" class="btn btn-primary btn-sm text-white" title="Detail" data-toggle="modal" data-target="#detailGuruModal-{{ $g->id }}">
                  <i class="bi bi-eye"></i>
                </a>
          </td>
        </tr>
      @endforeach
    </tbody>
  </table>
</div>
                </div>
              </div>
            </div>

<div class="modal fade" id="detailGuruModal-{{ $g->id }}" tabindex="-1" role="dialog" aria-labelledby="detailGuruModalLabel-{{ $g->id }}" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="detailGuruModalLabel-{{ $g->id }}">Detail Kepala Sekolah</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Tutup">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                    <div class="mb-3">
                        <label>Nama</label>
                        <input type="text" class="form-control" value="{{ $g->user->name }}" disabled>
                    </div>
                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" class="form-control" value="{{ $g->user->email }}" disabled>
                    </div>
                    <div class="mb-3">
                        <label>NIP</label>
                        <input type="text" class="form-control" value="{{ $g->nip }}" disabled>
                    </div>

                    <div class="mb-3">
                        <label>Jenis Kelamin</label>
                        <input type="text" class="form-control" value="{{ $g->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}" disabled>
                    </div>

                    <div class="mb-3">
                        <label>No Handphone</label>
                        <input type="text" class="form-control" value="{{ $g->no_hp }}" disabled>
                    </div>
            </div>

            <div class="modal-footer w-100">
                <div class="row w-100 d-flex justify-content-center">
                    <div class="col-12 col-lg-auto mb-2">
                        <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>



@endsection