@extends('backend.layout.template_siswa')
@section('content')

<div class="col-lg-12 grid-margin stretch-card">
  <div class="card">
                <div class="card-body">
                  <h4 class="card-title">DATA DIRI</h4>
                  <div class="table-responsive">
                    <table class="table table-striped">
                      <thead>
                        <tr class="text-center">
                          <th>NISN</th>
                          <th>Nama</th>
                          <th>Kelas</th>
                          <!-- <th>Nomor HP</th> -->
                          <!-- <th>Email</th> -->
                          <th>Aksi</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr class="text-center">
                          <td>{{ $siswa->nisn ?? '-' }}</td>
                          <td>{{ $siswa->user->name ?? '-' }}</td>
                          <td>
                            @if($kelasAktif)
                              {{ $kelasAktif->nama }}
                            @else
                              <span class="text-muted">Belum terdaftar</span>
                            @endif
                          </td>
                          <td>
                              <a href="#" class="btn btn-warning btn-sm text-white" title="Edit" data-toggle="modal" data-target="#editProfilModal-{{ $siswa->id }}">
                                <i class="mdi mdi-pencil"></i>
                              </a>
                            <a href="#" class="btn btn-primary btn-sm text-white" title="Detail" data-toggle="modal" data-target="#detailProfilModal-{{ $siswa->id }}">
                              <i class="bi bi-eye"></i>
                            </a>
                          </td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
            
<!-- Modal Edit -->
<div class="modal fade" id="editProfilModal-{{ $siswa->id }}" tabindex="-1" role="dialog" aria-labelledby="editProfilModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <form id="siswaForm-{{ $siswa->id }}" action="{{ route('siswa.update', $siswa->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="modal-header">
          <h5 class="modal-title">Edit Data Siswa</h5>
          <button type="button" class="close" data-dismiss="modal">
            <span>&times;</span>
          </button>
        </div>

        <div class="modal-body">
          <div class="tab-content">
            <div id="step1" class="tab-pane fade show active">
              @include('backend.siswa.wizard.data_diri')
            </div>
            <div id="step2" class="tab-pane fade">
              @include('backend.siswa.wizard.alamat_lengkap')
            </div>
            <div id="step3" class="tab-pane fade">
              @include('backend.siswa.wizard.dokumen_identitas')
              <div class="mt-3 form-group">
                <label for="lanjut_kip"><strong>Lanjut ke:</strong></label>
                <select name="lanjut_kip" id="lanjut_kip" class="form-control form-check form-check-inline" required>
                  <option value="" selected hidden>Pilih</option>
                  <option value="ortu" id="kip_ortu">
                    Data Ayah & Ibu
                  </option>
                  <option value="wali" id="kip_wali">
                    Data Wali
                  </option>
                </select>
              </div>
            </div>
            <div id="step4" class="tab-pane fade">
              @include('backend.siswa.wizard.data_ayah')
            </div>
            <div id="step5" class="tab-pane fade">
              @include('backend.siswa.wizard.data_ibu')
            </div>
            <div id="step6" class="tab-pane fade">
              @include('backend.siswa.wizard.data_wali')
            </div>
            <div id="step7" class="tab-pane fade">
              @include('backend.siswa.wizard.data_fisik')
            </div>
            <div id="step8" class="tab-pane fade">
              @include('backend.siswa.wizard.bantuan_sosial')
            </div>
            <div id="step9" class="tab-pane fade">
              @include('backend.siswa.wizard.data_rekening')
            </div>
            <div id="step10" class="tab-pane fade">
              @include('backend.siswa.wizard.daftar_ulang')
            </div>
          </div>
        </div>

        <div class="modal-footer w-100">
  <div class="row w-100 d-flex justify-content-between">
    <div class="col-12 col-lg-auto mb-2">
      <button type="button" class="btn btn-secondary w-100 w-lg-auto" id="prevBtn">Kembali</button>
    </div>
    <div class="col-12 col-lg-auto mb-2">
      <button type="button" class="btn btn-primary w-100 w-lg-auto" id="nextBtn">Selanjutnya</button>
      <button type="submit" class="btn btn-warning w-100 w-lg-auto d-none" id="submitBtn">Simpan</button>
    </div>
  </div>
</div>

      </form>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const form      = document.getElementById('siswaForm-{{ $siswa->id }}');
  const nextBtn   = document.getElementById('nextBtn');
  const prevBtn   = document.getElementById('prevBtn');
  const submitBtn = document.getElementById('submitBtn');

  const steps = ['step1','step2','step3','step4','step5','step6','step7','step8','step9','step10'];
  let current = 0;

  function usingOrtu() { return form.lanjut_kip.value === 'ortu'; }
  function usingWali() { return form.lanjut_kip.value === 'wali'; }

  function showStep(i) {
    steps.forEach(id => document.getElementById(id).classList.remove('show','active'));
    document.getElementById(steps[i]).classList.add('show','active');
    prevBtn.style.display = i===0 ? 'none' : 'inline-block';
    if (i===steps.length-1) {
      nextBtn.classList.add('d-none');
      submitBtn.classList.remove('d-none');
    } else {
      nextBtn.classList.remove('d-none');
      submitBtn.classList.add('d-none');
    }
  }

  function getNext() {
    let i = current+1;
    if (usingWali() && (i===3||i===4)) i=5;
    if (usingOrtu() && i===5) i=6;
    return i;
  }
  function getPrev() {
    let i = current-1;
    if (usingWali() && (i===4||i===3)) i=2;
    if (usingOrtu() && i===5) i=4;
    return i;
  }

  nextBtn.addEventListener('click', () => {
    const pane = document.getElementById(steps[current]);
    const elems = pane.querySelectorAll('input,select,textarea');
    for (let el of elems) {
      if (!el.checkValidity()) { el.reportValidity(); return; }
    }
    current = getNext(); showStep(current);
  });

  prevBtn.addEventListener('click', () => {
    current = getPrev(); showStep(current);
  });

  showStep(0);
});
</script>

<div class="modal fade" id="detailProfilModal-{{ $siswa->id }}" tabindex="-1" role="dialog" aria-labelledby="detailProfilModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Detail Data Siswa</h5>
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
      </div>

      <div class="modal-body">
        {{-- STEP 1 --}}
        <h6 class="text-primary">Step 1: Data Diri</h6>
        <hr>
        @include('backend.siswa.wizard.data_diri')

        {{-- STEP 2 --}}
        <h6 class="text-primary mt-4">Step 2: Alamat Lengkap</h6>
        <hr>
        @include('backend.siswa.wizard.alamat_lengkap')

        {{-- STEP 3 --}}
        <h6 class="text-primary mt-4">Step 3: Dokumen Identitas</h6>
        <hr>
        @include('backend.siswa.wizard.dokumen_identitas')

        {{-- STEP 4 & 5: Orang Tua --}}
          <h6 class="text-primary mt-4">Step 4: Data Ayah</h6>
          <hr>
          @include('backend.siswa.wizard.data_ayah')

          <h6 class="text-primary mt-4">Step 5: Data Ibu</h6>
          <hr>
          @include('backend.siswa.wizard.data_ibu')

        {{-- STEP 6: Wali --}}
          <h6 class="text-primary mt-4">Step 4: Data Wali</h6>
          <hr>
          @include('backend.siswa.wizard.data_wali')

        {{-- STEP 7 --}}
        <h6 class="text-primary mt-4">Step 6: Data Fisik</h6>
        <hr>
        @include('backend.siswa.wizard.data_fisik')

        {{-- STEP 8 --}}
        <h6 class="text-primary mt-4">Step 7: Bantuan Sosial</h6>
        <hr>
        @include('backend.siswa.wizard.bantuan_sosial')

        {{-- STEP 9 --}}
        <h6 class="text-primary mt-4">Step 8: Data Rekening</h6>
        <hr>
        @include('backend.siswa.wizard.data_rekening')
      </div>

      <div class="modal-footer w-100">
        <div class="row w-100 d-flex justify-content-center">
          <div class="col-12 col-lg-auto mb-2">
            <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll('[id^="detailProfilModal-"]').forEach(function(modal) {
    modal.querySelectorAll('input, textarea, select').forEach(function(el) {
      el.disabled = true;
    });
  });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const steps = [
    'detail-step1-{{ $siswa->id }}',
    'detail-step2-{{ $siswa->id }}',
    'detail-step3-{{ $siswa->id }}',
    'detail-step4-{{ $siswa->id }}',
    'detail-step5-{{ $siswa->id }}',
    'detail-step6-{{ $siswa->id }}',
    'detail-step7-{{ $siswa->id }}',
    'detail-step8-{{ $siswa->id }}',
    'detail-step9-{{ $siswa->id }}'
  ];

  let current = 0;

  const nextBtn = document.getElementById('detail-nextBtn-{{ $siswa->id }}');
  const prevBtn = document.getElementById('detail-prevBtn-{{ $siswa->id }}');

  const lanjutKip = document.getElementById('detail_lanjut_kip_{{ $siswa->id }}');
  function usingOrtu() { return lanjutKip?.value === 'ortu'; }
  function usingWali() { return lanjutKip?.value === 'wali'; }

  function showStep(i) {
    steps.forEach(id => document.getElementById(id).classList.remove('show', 'active'));
    document.getElementById(steps[i]).classList.add('show', 'active');
    prevBtn.style.display = i === 0 ? 'none' : 'inline-block';
    nextBtn.style.display = i === steps.length - 1 ? 'none' : 'inline-block';
  }

  function getNext() {
    let i = current + 1;
    if (usingWali() && (i === 3 || i === 4)) i = 5;
    if (usingOrtu() && i === 5) i = 6;
    return Math.min(i, steps.length - 1);
  }

  function getPrev() {
    let i = current - 1;
    if (usingWali() && (i === 4 || i === 3)) i = 2;
    if (usingOrtu() && i === 5) i = 4;
    return Math.max(i, 0);
  }

  nextBtn.addEventListener('click', () => {
    current = getNext();
    showStep(current);
  });

  prevBtn.addEventListener('click', () => {
    current = getPrev();
    showStep(current);
  });

  $('#detailProfilModal-{{ $siswa->id }}').on('shown.bs.modal', function () {
    $(this).find('input, select, textarea').attr('disabled', true);
    // Khusus untuk select kip tetap diaktifkan
    $('#detail_lanjut_kip_{{ $siswa->id }}').removeAttr('disabled');
    current = 0;
    showStep(current);
  });
});
</script>

<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>

<script>
  @if (session('success'))
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: '{{ session('success') }}',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('error'))
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ session('error') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if (session('warning'))
    Swal.fire({
      icon: 'warning',
      title: 'Peringatan!',
      text: '{{ session('warning') }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif

  @if ($errors->any())
    Swal.fire({
      icon: 'error',
      title: 'Gagal!',
      text: '{{ $errors->first() }}',
      confirmButtonColor: '#d33',
      customClass: { popup: 'swal-popup-tall' }
    });
  @endif
</script>

@endsection