
<?php $__env->startSection('content'); ?>

<?php
  date_default_timezone_set('Asia/Jakarta');
  $hour = date('H');
  if ($hour >= 5 && $hour < 11) {
    $greeting = 'Selamat pagi';
  } elseif ($hour >= 11 && $hour < 15) {
    $greeting = 'Selamat siang';
  } elseif ($hour >= 15 && $hour < 18) {
    $greeting = 'Selamat sore';
  } else {
    $greeting = 'Selamat malam';
  }
?>

<h3 style="margin-bottom: 30px">Selamat datang di halaman guru bk</h3>

<div class="alert alert-success shadow-sm mb-5">
  <h5><?php echo e($greeting); ?>, <?php echo e(Auth::user()->name); ?>!</h5>
  <p>Semangat menjalankan tugas hari ini!</p>
</div>


<style>
  .swal-popup-tall {
    height: 400px !important;
    display: flex;
    flex-direction: column;
    justify-content: center;
  }
</style>
<script>
  <?php if(session('success')): ?>
    Swal.fire({
      icon: 'success',
      title: 'Berhasil!',
      text: 'Selamat datang <?php echo e(Auth::user()->name); ?> di halaman bk',
      confirmButtonColor: '#3085d6',
      customClass: { popup: 'swal-popup-tall' }
    });
  <?php endif; ?>

  <?php if(session('sukses')): ?>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: 'Data layanan parenting berhasil di update!',
                confirmButtonColor: '#3085d6',
                customClass: {
                    popup: 'swal-popup-tall',
                }
            });
        <?php endif; ?>

</script>


<div class="row">
  <div class="col-12 grid-margin stretch-card">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">DATA LAYANAN PARENTING</h4>
        <div class="table-responsive">
          <table class="table table-striped text-center">
            <thead>
              <tr>
                <th>No</th>
                <th>Tanggal</th>
                <th>Murid</th>
                <th>NISN</th>
                <th>Permasalahan</th>
                <th>Penyelesaian</th>
                <th>Hasil</th>
                <th>Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $layanans_parenting; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $layanan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if(is_null($layanan->penyelesaian) && is_null($layanan->hasil)): ?>
                <tr>
                  <td><?php echo e($index + 1); ?></td>
                  <td class="tanggal"><?php echo e(\Carbon\Carbon::parse($layanan->tanggal)->translatedFormat('d F Y')); ?></td>
                  <td class="nama"><?php echo e($layanan->siswa->name ?? '-'); ?></td>
                  <td class="nisn"><?php echo e($layanan->siswa->siswa->nisn ?? '-'); ?></td>
                  <td><?php echo e($layanan->permasalahan); ?></td>
                  <td style="color: #dc3545">Belum dijawab</td>
                  <td style="color: #dc3545">Belum dijawab</td>
                  <td>
                    <button type="button" class="btn btn-warning btn-sm text-white" title="Edit Status"
                      data-toggle="modal" data-target="#HasilLayananParenting<?php echo e($layanan->id); ?>">
                      <i class="mdi mdi-pencil"></i>
                    </button>
                  </td>
                </tr>

                <!-- Modal tetap ditampilkan untuk layanan yang belum dijawab -->
                <div class="modal fade" id="HasilLayananParenting<?php echo e($layanan->id); ?>" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-md modal-dialog-centered">
                    <div class="modal-content">
                      <form action="<?php echo e(route('bk.hasilLayanan.update', $layanan->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-header">
                          <h5 class="modal-title">Edit Hasil Layanan</h5>
                          <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body mb-3">
                          <div class="d-flex flex-column flex-md-row justify-content-md-between">
                            <p><strong>Nama:</strong> <span class="text-danger"><?php echo e($layanan->siswa->name); ?></span></p>
                            <p><strong>Tanggal Layanan:</strong> <span class="text-danger"><?php echo e(\Carbon\Carbon::parse($layanan->tanggal)->translatedFormat('d F Y')); ?></span></p>
                          </div>
                          <hr>
                          <div class="form-group">
                            <label>Permasalahan</label>
                            <textarea class="form-control" rows="3" readonly><?php echo e($layanan->permasalahan); ?></textarea>
                          </div>
                          <div class="form-group">
                            <label>Penyelesaian</label>
                            <textarea name="penyelesaian" class="form-control" rows="3" required><?php echo e($layanan->penyelesaian); ?></textarea>
                          </div>
                          <div class="form-group">
                            <label>Hasil</label>
                            <textarea name="hasil" class="form-control" rows="3" required><?php echo e($layanan->hasil); ?></textarea>
                          </div>
                        </div>
                        <div class="modal-footer w-100">
                          <div class="row w-100 d-flex justify-content-between">
                            <div class="col-12 col-lg-auto mb-2">
                              <button type="button" class="btn btn-secondary w-100 w-lg-auto" data-dismiss="modal">Tutup</button>
                            </div>
                            <div class="col-12 col-lg-auto mb-2">
                              <button type="submit" class="btn btn-warning w-100 w-lg-auto">Update</button>
                            </div>
                          </div>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
                <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                  <td colspan="8">Belum ada data layanan.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layout.template_bk', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\silakan\resources\views/backend/bk/index.blade.php ENDPATH**/ ?>