<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mapel extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'mapels';
    
    protected $fillable = ['nama', 'tipe'];

    protected $dates = ['deleted_at'];

    public function kelasMapel()
    {
        return $this->hasMany(KelasMapel::class);
    }

    public function getTipeLabelAttribute()
    {
        return $this->tipe ? 'Mapel Penilaian' : 'Mapel Non Penilaian';
    }
}
